/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.provider;

import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.jingle.jingle.nat.ICECandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.packet.JingleTransport;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public abstract class JingleTransportProvider
extends ExtensionHandler {
    private JingleTransport trans;

    protected JingleTransport getInstance() {
        return new JingleTransport();
    }

    public void startHandling(Attributes attributes) {
        this.trans = this.getInstance();
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("candidate")) {
            JingleTransport.JingleTransportCandidate jingleTransportCandidate = this.parseCandidate(attributes);
            if (jingleTransportCandidate != null) {
                this.trans.addCandidate(jingleTransportCandidate);
            }
        } else {
            Log.notParsedXML((String)("Unknown tag \"" + string + "\" in transport element."));
        }
    }

    public Extension build() {
        return this.trans;
    }

    protected abstract JingleTransport.JingleTransportCandidate parseCandidate(Attributes var1);

    public static class RawUdp
    extends JingleTransportProvider {
        protected JingleTransport getInstance() {
            return new JingleTransport.RawUdp();
        }

        protected JingleTransport.JingleTransportCandidate parseCandidate(Attributes attributes) {
            TransportCandidate.Fixed fixed = new TransportCandidate.Fixed();
            String string = attributes.getValue("generation");
            String string2 = attributes.getValue("ip");
            String string3 = attributes.getValue("name");
            String string4 = attributes.getValue("port");
            if (string != null) {
                try {
                    fixed.setGeneration(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                fixed.setIp(string2);
            }
            if (string3 != null) {
                fixed.setName(string3);
            }
            if (string4 != null) {
                try {
                    fixed.setPort(Integer.parseInt(string4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new JingleTransport.RawUdp.Candidate(fixed);
        }
    }

    public static class Ice
    extends JingleTransportProvider {
        protected JingleTransport getInstance() {
            return new JingleTransport.Ice();
        }

        protected JingleTransport.JingleTransportCandidate parseCandidate(Attributes attributes) {
            ICECandidate iCECandidate = new ICECandidate();
            String string = attributes.getValue("channel");
            String string2 = attributes.getValue("generation");
            String string3 = attributes.getValue("ip");
            String string4 = attributes.getValue("name");
            String string5 = attributes.getValue("network");
            String string6 = attributes.getValue("username");
            String string7 = attributes.getValue("password");
            String string8 = attributes.getValue("port");
            String string9 = attributes.getValue("preference");
            String string10 = attributes.getValue("proto");
            String string11 = attributes.getValue("type");
            if (string != null) {
                iCECandidate.setChannel(new TransportCandidate.Channel(string));
            }
            if (string2 != null) {
                try {
                    iCECandidate.setGeneration(Integer.parseInt(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string3 == null) {
                return null;
            }
            iCECandidate.setIp(string3);
            if (string4 != null) {
                iCECandidate.setName(string4);
            }
            if (string5 != null) {
                try {
                    iCECandidate.setNetwork(Integer.parseInt(string5));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string6 != null) {
                iCECandidate.setUsername(string6);
            }
            if (string7 != null) {
                iCECandidate.setPassword(string7);
            }
            if (string8 != null) {
                try {
                    iCECandidate.setPort(Integer.parseInt(string8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string9 != null) {
                try {
                    iCECandidate.setPreference(Integer.parseInt(string9));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string10 != null) {
                iCECandidate.setProto(new TransportCandidate.Protocol(string10));
            }
            if (string11 != null) {
                iCECandidate.setType(ICECandidate.Type.valueOf(string11));
            }
            return new JingleTransport.Ice.Candidate(iCECandidate);
        }
    }
}

