/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.idle;

import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.StatusChangeListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.idle.IdleTimer;
import nu.fw.jeti.ui.StatusButton;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
StatusChangeListener {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "idle.Sets_status_to_away_when_no_activity";
    public static final String MIN_JETI_VERSION = "0.5";
    public static final String NAME = "idle";
    public static final String ABOUT = "by E.S. de Boer, uses idletrack from GAIM";
    private volatile boolean idle = false;
    private boolean sleeping = true;
    private int show;
    private String status;
    private IdleTimerThread thread;
    private static Plugin plugin;

    public static void init(Backend backend) throws InstantiationException {
        plugin = new Plugin(backend);
    }

    public Plugin(Backend backend) throws InstantiationException {
        try {
            if (!IdleTimer.IdleInit()) {
                throw new InstantiationException("Idle library error");
            }
            backend.addListener(StatusChangeListener.class, (JETIListener)this);
            this.thread = new IdleTimerThread();
            this.thread.start();
        }
        catch (Throwable throwable) {
            throw new InstantiationException("Idle library error");
        }
    }

    public void unload() {
    }

    public static void setParameters(int n, String string, int n2, String string2) {
        Plugin.plugin.thread.setParameters(n, string, n2, string2);
    }

    public static void unload(Backend backend) {
        if (Plugin.plugin.thread != null) {
            Plugin.plugin.thread.interrupt();
        }
        IdleTimer.IdleTerm();
        backend.removeListener(StatusChangeListener.class, (JETIListener)plugin);
        plugin = null;
    }

    public void ownPresenceChanged(int n, String string) {
        if (n == 2 || n == 1) {
            if (!this.idle) {
                this.show = n;
                this.status = string;
                if (this.sleeping) {
                    this.thread.awake();
                    this.sleeping = false;
                }
            }
        } else if (!this.sleeping && !this.idle) {
            this.thread.sleep();
            this.sleeping = true;
        }
    }

    public void connectionChanged(boolean bl) {
        if (!bl) {
            this.thread.sleep();
            this.sleeping = true;
        }
    }

    public void exit() {
    }

    class IdleTimerThread
    extends Thread {
        private static final int SLEEP_TIME_ACTIVE = 60000;
        private static final int SLEEP_TIME_AWAY = 10000;
        private long lastActivity;
        private volatile int idleAwayTime = Preferences.getInteger((String)"idle", (String)"minutesAway", (int)5) * 60000;
        private volatile String awayMessage = Preferences.getString((String)"idle", (String)"awayMessage", (String)"Idle");
        private volatile int idleXATime = Preferences.getInteger((String)"idle", (String)"minutesXA", (int)20) * 60000;
        private volatile String xaMessage = Preferences.getString((String)"idle", (String)"XAMessage", (String)"Idle");
        private long lastMoved;
        private volatile boolean sleep = true;
        private boolean xa = false;
        private int sleepTime = 60000;

        IdleTimerThread() {
        }

        public void setParameters(int n, String string, int n2, String string2) {
            this.idleAwayTime = n * 60000;
            this.awayMessage = string;
            this.idleXATime = n2 * 60000;
            this.xaMessage = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                long l = IdleTimer.IdleGetLastInputTime();
                if (this.sleep) {
                    IdleTimerThread idleTimerThread = this;
                    synchronized (idleTimerThread) {
                        try {
                            if (this.sleep) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
                if (l != this.lastActivity) {
                    this.lastActivity = l;
                    this.lastMoved = System.currentTimeMillis();
                    if (Plugin.this.idle) {
                        StatusButton.changeStatus((int)Plugin.this.show, (String)Plugin.this.status);
                        Plugin.this.idle = false;
                        this.xa = false;
                        this.sleepTime = 60000;
                    }
                } else if (!Plugin.this.idle) {
                    if (System.currentTimeMillis() >= this.lastMoved + (long)this.idleAwayTime) {
                        this.sleepTime = 10000;
                        Plugin.this.idle = true;
                        StatusButton.changeStatus((int)3, (String)this.awayMessage);
                    }
                } else if (!this.xa && System.currentTimeMillis() >= this.lastMoved + (long)this.idleXATime) {
                    this.xa = true;
                    StatusButton.changeStatus((int)5, (String)this.xaMessage);
                }
                if (this.isInterrupted()) continue;
                try {
                    IdleTimerThread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            System.out.println("out of loop");
        }

        public void sleep() {
            this.sleep = true;
        }

        public synchronized void awake() {
            this.sleep = false;
            this.notifyAll();
        }
    }
}

