/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.ComponentOrientation;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.print.attribute.standard.MediaSize;

public class Language {
    public static final String AD_Language_en_US = "en_US";
    private static final String AD_Language_en_GB = "en_GB";
    private static final String AD_Language_de_DE = "de_DE";
    private static final String AD_Language_it_IT = "it_IT";
    private static final String AD_Language_es_ES = "es_ES";
    private static final String AD_Language_fr_FR = "fr_FR";
    private static final String AD_Language_bg_BG = "bg_BG";
    private static final String AD_Language_th_TH = "th_TH";
    private static final String AD_Language_pl_PL = "pl_PL";
    private static final String AD_Language_zh_TW = "zh_TW";
    private static Language[] s_languages;
    private static Language s_defaultLanguage;
    private String m_name;
    private String m_AD_Language;
    private Locale m_locale;
    private Boolean m_decimalPoint;
    private SimpleDateFormat m_dateFormat;
    private MediaSize m_mediaSize = MediaSize.ISO.A4;

    public static int getLanguageCount() {
        return s_languages.length;
    }

    public static Language getLanguage(int index) {
        if (index < 0 || index >= s_languages.length) {
            return s_defaultLanguage;
        }
        return s_languages[index];
    }

    public static void addLanguage(Language language) {
        if (language == null) {
            return;
        }
        ArrayList<Language> list = new ArrayList<Language>(Arrays.asList(s_languages));
        list.add(language);
        s_languages = new Language[list.size()];
        list.toArray(s_languages);
    }

    public static Language getLanguage(String langInfo) {
        String lang = langInfo;
        if (lang == null || lang.length() == 0) {
            lang = System.getProperty("user.language", "");
        }
        int i = 0;
        while (i < s_languages.length) {
            if (lang.equals(s_languages[i].getName()) || lang.equals(s_languages[i].getLanguageCode()) || lang.equals(s_languages[i].getAD_Language())) {
                return s_languages[i];
            }
            ++i;
        }
        return s_defaultLanguage;
    }

    public static boolean isBaseLanguage(String langInfo) {
        return langInfo == null || langInfo.length() == 0 || langInfo.equals(s_languages[0].getName()) || langInfo.equals(s_languages[0].getLanguageCode()) || langInfo.equals(s_languages[0].getAD_Language());
    }

    public static Language getBaseLanguage() {
        return s_languages[0];
    }

    public static String getBaseAD_Language() {
        return s_languages[0].getAD_Language();
    }

    public static Locale getLocale(String langInfo) {
        return Language.getLanguage(langInfo).getLocale();
    }

    public static String getAD_Language(String langInfo) {
        return Language.getLanguage(langInfo).getAD_Language();
    }

    public static String getAD_Language(Locale locale) {
        if (locale != null) {
            int i = 0;
            while (i < s_languages.length) {
                if (locale.equals(s_languages[i].getLocale())) {
                    return s_languages[i].getAD_Language();
                }
                ++i;
            }
        }
        return s_defaultLanguage.getAD_Language();
    }

    public static String getName(String langInfo) {
        return Language.getLanguage(langInfo).getName();
    }

    public static boolean isDecimalPoint(String langInfo) {
        return Language.getLanguage(langInfo).isDecimalPoint();
    }

    public static String[] getNames() {
        String[] retValue = new String[s_languages.length];
        int i = 0;
        while (i < s_languages.length) {
            retValue[i] = s_languages[i].getName();
            ++i;
        }
        return retValue;
    }

    public static Language getLanguage() {
        return s_defaultLanguage;
    }

    public static void setLanguage(Language language) {
        if (language != null) {
            s_defaultLanguage = language;
            System.out.println(s_defaultLanguage);
        }
    }

    public Language(String name, String AD_Language, Locale locale, Boolean decimalPoint, String javaDatePattern, MediaSize mediaSize) {
        if (name == null || AD_Language == null || locale == null) {
            throw new IllegalArgumentException("Language - parameter is null");
        }
        this.m_name = name;
        this.m_AD_Language = AD_Language;
        this.m_locale = locale;
        this.m_decimalPoint = decimalPoint;
        this.setDateFormat(javaDatePattern);
        this.setMediaSize(mediaSize);
    }

    public String getName() {
        return this.m_name;
    }

    public String getAD_Language() {
        return this.m_AD_Language;
    }

    public void setAD_Language(String AD_Language) {
        if (AD_Language != null) {
            this.m_AD_Language = AD_Language;
            System.out.println(this.toString());
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.m_locale = locale;
        this.m_decimalPoint = null;
    }

    public String getLanguageCode() {
        return this.m_locale.getLanguage();
    }

    public boolean isLeftToRight() {
        return ComponentOrientation.getOrientation(this.m_locale).isLeftToRight();
    }

    public boolean isDecimalPoint() {
        if (this.m_decimalPoint == null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.m_locale);
            this.m_decimalPoint = new Boolean(dfs.getDecimalSeparator() == '.');
        }
        return this.m_decimalPoint;
    }

    public boolean isBaseLanguage() {
        return this.equals(Language.getBaseLanguage());
    }

    public void setDateFormat(String javaDatePattern) {
        if (javaDatePattern == null) {
            return;
        }
        this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.m_locale);
        try {
            this.m_dateFormat.applyPattern(javaDatePattern);
        }
        catch (Exception e) {
            System.err.println("Language.setDateFormat " + javaDatePattern + " - " + e);
            this.m_dateFormat = null;
        }
    }

    public SimpleDateFormat getDateFormat() {
        if (this.m_dateFormat == null) {
            int i;
            String nFormat;
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.m_locale);
            String sFormat = this.m_dateFormat.toPattern();
            if (sFormat.indexOf("MM") == -1 && sFormat.indexOf("dd") == -1) {
                nFormat = "";
                i = 0;
                while (i < sFormat.length()) {
                    nFormat = sFormat.charAt(i) == 'M' ? nFormat + "MM" : (sFormat.charAt(i) == 'd' ? nFormat + "dd" : nFormat + sFormat.charAt(i));
                    ++i;
                }
                this.m_dateFormat.applyPattern(nFormat);
            }
            if (this.m_dateFormat.toPattern().length() != 8) {
                this.m_dateFormat.applyPattern("yyyy-MM-dd");
            }
            if (this.m_dateFormat.toPattern().indexOf("yyyy") == -1) {
                sFormat = this.m_dateFormat.toPattern();
                nFormat = "";
                i = 0;
                while (i < sFormat.length()) {
                    nFormat = sFormat.charAt(i) == 'y' ? nFormat + "yy" : nFormat + sFormat.charAt(i);
                    ++i;
                }
                this.m_dateFormat.applyPattern(nFormat);
            }
            this.m_dateFormat.setLenient(true);
        }
        return this.m_dateFormat;
    }

    public SimpleDateFormat getDateTimeFormat() {
        SimpleDateFormat retValue = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 1, this.m_locale);
        return retValue;
    }

    public SimpleDateFormat getTimeFormat() {
        return (SimpleDateFormat)DateFormat.getTimeInstance(1, this.m_locale);
    }

    public String getDBdatePattern() {
        return this.getDateFormat().toPattern().toUpperCase(this.m_locale);
    }

    public MediaSize getMediaSize() {
        return this.m_mediaSize;
    }

    public void setMediaSize(MediaSize size) {
        if (size != null) {
            this.m_mediaSize = size;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Language=[");
        sb.append(this.m_name).append(",Locale=").append(this.m_locale.toString()).append(",AD_Language=").append(this.m_AD_Language).append(",DatePattern=").append(this.getDBdatePattern()).append(",DecimalPoint=").append(this.isDecimalPoint()).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.m_AD_Language.hashCode();
    }

    public boolean equals(Object obj) {
        Language cmp;
        return obj instanceof Language && (cmp = (Language)obj).getAD_Language().equals(this.m_AD_Language);
    }

    public static void main(String[] args) {
        System.out.println(Locale.TRADITIONAL_CHINESE);
        System.out.println(Locale.TAIWAN);
        System.out.println(Locale.SIMPLIFIED_CHINESE);
        System.out.println(Locale.CHINESE);
        System.out.println(Locale.PRC);
    }

    static {
        AD_Language_en_US = AD_Language_en_US;
        AD_Language_en_GB = AD_Language_en_GB;
        AD_Language_de_DE = AD_Language_de_DE;
        AD_Language_it_IT = AD_Language_it_IT;
        AD_Language_es_ES = AD_Language_es_ES;
        AD_Language_fr_FR = AD_Language_fr_FR;
        AD_Language_bg_BG = AD_Language_bg_BG;
        AD_Language_th_TH = AD_Language_th_TH;
        AD_Language_pl_PL = AD_Language_pl_PL;
        AD_Language_zh_TW = AD_Language_zh_TW;
        s_languages = new Language[]{new Language("English", AD_Language_en_US, Locale.US, null, null, MediaSize.NA.LETTER), new Language("English UK", AD_Language_en_GB, Locale.UK, null, null, MediaSize.ISO.A4), new Language("Deutsch", AD_Language_de_DE, Locale.GERMANY, null, null, MediaSize.ISO.A4), new Language("Italiano", AD_Language_it_IT, Locale.ITALY, null, null, MediaSize.ISO.A4), new Language("Fran\u00e7ais", AD_Language_fr_FR, Locale.FRANCE, null, null, MediaSize.ISO.A4), new Language("\u7e41\u9ad4\u4e2d\u6587 (Big5)", AD_Language_zh_TW, Locale.TAIWAN, null, null, MediaSize.ISO.A4), new Language("Espa\u00f1ol", AD_Language_es_ES, new Locale("es", "ES"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438", AD_Language_bg_BG, new Locale("bg", "BG"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Thai", AD_Language_th_TH, new Locale("th", "TH"), new Boolean(false), "dd/MM/yyyy", MediaSize.ISO.A4), new Language("Polski", AD_Language_pl_PL, new Locale("pl", "PL"), new Boolean(false), "dd-MM-yyyy", MediaSize.ISO.A4)};
        s_defaultLanguage = s_languages[0];
    }
}

