/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.translate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import nu.fw.jeti.plugins.translate.Direction;
import nu.fw.jeti.plugins.translate.Language;

public class BabelFishTranslator
implements Serializable {
    private Hashtable words = new Hashtable(4096);
    private boolean rememberText = false;

    public String translate(Direction direction, String string, boolean bl, int n) {
        this.rememberText = bl;
        if (bl && this.words.containsKey(string)) {
            return this.translateLocal(direction, string);
        }
        return this.translateOnline(direction, string);
    }

    private String translateLocal(Direction direction, String string) {
        return (String)this.words.get(string);
    }

    private String translateOnline(Direction direction, String string) {
        try {
            int n;
            URL uRL = new URL("http://babelfish.altavista.com/babelfish/tr");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.6) Gecko/20040510");
            httpURLConnection.setRequestProperty("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,image/jpeg,image/gif;q=0.2,*/*;q=0.1");
            httpURLConnection.setRequestProperty("Accept-Language", "ru,en-us;q=0.7,en;q=0.3");
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            httpURLConnection.setRequestProperty("Accept-Charset", "utf-8;q=0.7,*;q=0.7");
            httpURLConnection.setRequestProperty("Keep-Alive", "300");
            httpURLConnection.setRequestProperty("Proxy-Connection", "close");
            httpURLConnection.setRequestProperty("Referer", "http://babelfish.av.com/");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.getOutputStream().write(("doit=done&intl=1&tt=urltext&urltext=" + string + "&lp=" + direction.getFromLanguage().getShortName().toLowerCase() + "_" + direction.getToLanguage().getShortName().toLowerCase()).getBytes());
            InputStream inputStream = httpURLConnection.getInputStream();
            String string2 = httpURLConnection.getHeaderField("Content-Encoding");
            if (string2 != null && string2.equals("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            httpURLConnection.disconnect();
            inputStream.close();
            Charset charset = Charset.forName("UTF-8");
            CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            String string3 = charsetDecoder.decode(byteBuffer).toString();
            String string4 = "<td bgcolor=white class=s><div style=padding:10px;>";
            int n2 = string3.indexOf(string4);
            if (n2 == -1) {
                return null;
            }
            int n3 = n2 + string4.length();
            String string5 = string3.substring(n3, string3.indexOf("</div>", n3));
            string5 = BabelFishTranslator.unescapeHTML(string5, 0);
            if (this.rememberText) {
                this.words.put(string, string5);
            }
            return string5;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static Direction[] getSupportedDirections() {
        Vector<Direction> vector = new Vector<Direction>();
        vector.add(new Direction(Language.ZH, Language.EN));
        vector.add(new Direction(Language.ZT, Language.EN));
        vector.add(new Direction(Language.EN, Language.ZH));
        vector.add(new Direction(Language.EN, Language.ZT));
        vector.add(new Direction(Language.EN, Language.NL));
        vector.add(new Direction(Language.EN, Language.FR));
        vector.add(new Direction(Language.EN, Language.DE));
        vector.add(new Direction(Language.EN, Language.EL));
        vector.add(new Direction(Language.EN, Language.IT));
        vector.add(new Direction(Language.EN, Language.JA));
        vector.add(new Direction(Language.EN, Language.KO));
        vector.add(new Direction(Language.EN, Language.PT));
        vector.add(new Direction(Language.EN, Language.RU));
        vector.add(new Direction(Language.EN, Language.ES));
        vector.add(new Direction(Language.NL, Language.EN));
        vector.add(new Direction(Language.NL, Language.FR));
        vector.add(new Direction(Language.FR, Language.EN));
        vector.add(new Direction(Language.FR, Language.DE));
        vector.add(new Direction(Language.FR, Language.EL));
        vector.add(new Direction(Language.FR, Language.IT));
        vector.add(new Direction(Language.FR, Language.PT));
        vector.add(new Direction(Language.FR, Language.NL));
        vector.add(new Direction(Language.FR, Language.ES));
        vector.add(new Direction(Language.DE, Language.EN));
        vector.add(new Direction(Language.DE, Language.FR));
        vector.add(new Direction(Language.EL, Language.EN));
        vector.add(new Direction(Language.EL, Language.FR));
        vector.add(new Direction(Language.IT, Language.EN));
        vector.add(new Direction(Language.IT, Language.FR));
        vector.add(new Direction(Language.JA, Language.EN));
        vector.add(new Direction(Language.KO, Language.EN));
        vector.add(new Direction(Language.PT, Language.EN));
        vector.add(new Direction(Language.PT, Language.FR));
        vector.add(new Direction(Language.RU, Language.EN));
        vector.add(new Direction(Language.ES, Language.EN));
        vector.add(new Direction(Language.ES, Language.FR));
        Object[] objectArray = new Direction[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static final String unescapeHTML(String string, int n) {
        String[][] stringArrayArray = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&amp;", "&"}, {"&quot;", "\""}, {"&agrave;", "\u00d0\u00b0"}, {"&Agrave;", "\u00d0?"}, {"&acirc;", "\u00d0\u00b2"}, {"&auml;", "\u00d0\u00b4"}, {"&Auml;", "\u00d0\u201d"}, {"&Acirc;", "\u00d0\u2019"}, {"&aring;", "\u00d0\u00b5"}, {"&Aring;", "\u00d0\u2022"}, {"&aelig;", "\u00d0\u00b6"}, {"&AElig;", "\u00d0\u2013"}, {"&ccedil;", "\u00d0\u00b7"}, {"&Ccedil;", "\u00d0\u2014"}, {"&eacute;", "\u00d0\u00b9"}, {"&Eacute;", "\u00d0\u2122"}, {"&egrave;", "\u00d0\u00b8"}, {"&Egrave;", "\u00d0\u02dc"}, {"&ecirc;", "\u00d0\u00ba"}, {"&Ecirc;", "\u00d0\u0161"}, {"&euml;", "\u00d0\u00bb"}, {"&Euml;", "\u00d0\u203a"}, {"&iuml;", "\u00d0\u00bf"}, {"&Iuml;", "\u00d0\u0178"}, {"&ocirc;", "\u00d1\u201e"}, {"&Ocirc;", "\u00d0\u00a4"}, {"&ouml;", "\u00d1\u2020"}, {"&Ouml;", "\u00d0\u00a6"}, {"&oslash;", "\u00d1\u02c6"}, {"&Oslash;", "\u00d0\u00a8"}, {"&szlig;", "\u00d0\u00af"}, {"&ugrave;", "\u00d1\u2030"}, {"&Ugrave;", "\u00d0\u00a9"}, {"&ucirc;", "\u00d1\u2039"}, {"&Ucirc;", "\u00d0\u00ab"}, {"&uuml;", "\u00d1\u0152"}, {"&Uuml;", "\u00d0\u00ac"}, {"&nbsp;", " "}, {"&reg;", "\u00a9"}, {"&copy;", "\u00ae"}, {"&euro;", "\u20a0"}};
        int n2 = string.indexOf("&", n);
        if (n2 > -1) {
            int n3 = string.indexOf(";", n2);
            n = n2 + 1;
            if (n3 > n2) {
                int n4;
                String string2 = string.substring(n2, n3 + 1);
                for (n4 = 0; n4 < stringArrayArray.length && !stringArrayArray[n4][0].equals(string2); ++n4) {
                }
                if (n4 < stringArrayArray.length) {
                    string = string.substring(0, n2) + stringArrayArray[n4][1] + string.substring(n3 + 1);
                    return BabelFishTranslator.unescapeHTML(string, n);
                }
                if (string2.startsWith("&#")) {
                    String string3 = string2.substring(2, string2.length() - 1);
                    int n5 = Integer.parseInt(string3, 10);
                    char[] cArray = new char[]{(char)n5};
                    string = string.substring(0, n2) + new String(cArray) + string.substring(n3 + 1);
                    return BabelFishTranslator.unescapeHTML(string, n);
                }
            }
        }
        return string;
    }

    public void clearCache() {
        this.words.clear();
    }
}

