/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import nu.fw.jeti.backend.Connect;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.Handlers;
import nu.fw.jeti.backend.Input;
import nu.fw.jeti.backend.JabberHandler;
import nu.fw.jeti.backend.Output;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.IQRegister;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.ui.RegisterWindow;

public class NewAccount
implements ConnectionPacketReceiver {
    private String server;
    private String username;
    private String password;
    private Output output;
    private String registerId = "";
    private RegisterWindow registerWindow;

    public NewAccount(String string, int n, Handlers handlers, String string2, String string3) {
        this.password = string3;
        this.username = string2;
        try {
            this.connect(string, n, handlers);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void connect(String string, int n, Handlers handlers) throws IOException {
        if (n == 5222) {
            n = 5223;
        }
        JabberHandler jabberHandler = new JabberHandler(this, handlers);
        Socket socket = new Connect.DummySSLSocketFactory().createSocket(string, n);
        new Input(socket.getInputStream(), this, jabberHandler);
        this.output = new Output(socket, string, this, socket.getOutputStream());
        this.server = string;
    }

    public void connected(String string, String string2) {
        this.send(new InfoQuery(new JID(this.server), "get", new IQRegister()));
    }

    public void receivePackets(Packet packet) {
        IQExtension iQExtension;
        if (this.registerId.equals(packet.getID())) {
            InfoQuery infoQuery = (InfoQuery)packet;
            if (infoQuery.getType().equals("result")) {
                this.registerWindow.login();
                this.output.disconnect(true);
            } else {
                this.registerWindow.error(packet.getErrorDescription());
            }
        } else if (packet instanceof InfoQuery && (iQExtension = packet.getIQExtension()) instanceof IQRegister) {
            new RegisterWindow(this, (IQRegister)iQExtension, this.username, this.password).setVisible(true);
        }
    }

    public void sendRegister(IQRegister iQRegister, RegisterWindow registerWindow) {
        this.registerWindow = registerWindow;
        this.registerId = "JetiRegister_" + new Date().getTime();
        this.send(new InfoQuery(null, "set", this.registerId, iQRegister));
    }

    public void inputDeath() {
        System.out.println("input death");
    }

    public void outputDeath() {
        System.out.println("input death");
    }

    public void send(Packet packet) {
        this.output.send(packet);
    }
}

