/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend.roster;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.JIDStatusTree;
import nu.fw.jeti.backend.roster.NormalJIDStatus;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.backend.roster.ResourceJIDStatus;
import nu.fw.jeti.backend.roster.SecondaryJIDStatus;
import nu.fw.jeti.backend.roster.Server;
import nu.fw.jeti.events.CompleteRosterListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.events.RosterListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.IQXRoster;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.RosterItem;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Roster
implements CompleteRosterListener,
PresenceListener {
    private JIDStatusTree jidTree;
    private static Map jidStatussen = new HashMap(32);
    private Backend backend;
    private boolean first;
    private Server server;

    public Roster(Backend backend, Server server) {
        this.server = server;
        this.backend = backend;
        backend.addListener(CompleteRosterListener.class, this);
        backend.addListener(PresenceListener.class, this);
    }

    public void rosterReceived(final InfoQuery infoQuery, final IQXRoster iQXRoster) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (infoQuery.getType().equals("result")) {
                    Roster.this.completeRoster(iQXRoster);
                } else if (infoQuery.getType().equals("set")) {
                    Iterator iterator = iQXRoster.getItems();
                    while (iterator.hasNext()) {
                        RosterItem rosterItem = (RosterItem)iterator.next();
                        JID jID = rosterItem.getJID();
                        String string = rosterItem.getName();
                        if (string == null) {
                            string = jID.toString();
                        }
                        NormalJIDStatus normalJIDStatus = (NormalJIDStatus)jidStatussen.get(jID);
                        if ("remove".equals(rosterItem.getSubscription())) {
                            Roster.this.removeFromRoster(normalJIDStatus, rosterItem, jID);
                            continue;
                        }
                        if (normalJIDStatus == null) {
                            if (rosterItem.getGroups() == null && jID.getUser() != null) continue;
                            Roster.this.addToRoster(string, rosterItem, jID);
                            continue;
                        }
                        Roster.this.changeItem(normalJIDStatus, string, rosterItem, jID);
                    }
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void completeRoster(IQXRoster iQXRoster) {
        jidStatussen = new HashMap(32);
        this.server.addJIDStatussen(jidStatussen);
        this.jidTree = new JIDStatusTree();
        this.server.clear();
        Iterator iterator = iQXRoster.getItems();
        while (iterator.hasNext()) {
            RosterItem rosterItem = (RosterItem)iterator.next();
            NormalJIDStatus normalJIDStatus = new NormalJIDStatus(rosterItem);
            jidStatussen.put(rosterItem.getJID(), normalJIDStatus);
            if (rosterItem.getJID().getUser() == null) {
                this.server.addServerNoFire(normalJIDStatus);
                continue;
            }
            if (rosterItem.getGroups() == null) {
                this.addJIDStatus(I18N.gettext("main.main.roster.Unfiled"), normalJIDStatus);
                continue;
            }
            Iterator iterator2 = rosterItem.getGroups().iterator();
            while (iterator2.hasNext()) {
                this.addJIDStatus((String)iterator2.next(), normalJIDStatus);
            }
        }
        this.backend.rosterLoaded();
        this.server.fire();
        iterator = this.backend.getListeners(RosterListener.class);
        while (iterator.hasNext()) {
            ((RosterListener)iterator.next()).rosterReplaced(this.jidTree);
        }
    }

    private void removeFromRoster(NormalJIDStatus normalJIDStatus, RosterItem rosterItem, JID jID) {
        if (normalJIDStatus == null) {
            return;
        }
        String string = normalJIDStatus.getNick();
        if (rosterItem.getJID().getUser() == null) {
            this.server.removeServer(string, normalJIDStatus);
        } else if (normalJIDStatus.groupCount() < 1) {
            this.removeJIDStatus(I18N.gettext("main.main.roster.Unfiled"), string, normalJIDStatus);
        } else {
            Iterator iterator = normalJIDStatus.getGroups();
            while (iterator.hasNext()) {
                this.removeJIDStatus((String)iterator.next(), string, normalJIDStatus);
            }
        }
        jidStatussen.remove(jID);
    }

    private void addToRoster(String string, RosterItem rosterItem, JID jID) {
        if (!(this.first || rosterItem.getGroups() != null && rosterItem.getName() != null)) {
            this.first = true;
            return;
        }
        this.first = false;
        NormalJIDStatus normalJIDStatus = new NormalJIDStatus(rosterItem);
        jidStatussen.put(jID, normalJIDStatus);
        if (jID.getUser() == null) {
            this.server.addServer(string, normalJIDStatus);
        } else if (rosterItem.getGroups() == null) {
            this.addJIDStatusFire(I18N.gettext("main.main.roster.Unfiled"), string, normalJIDStatus);
        } else {
            Iterator iterator = rosterItem.getGroups().iterator();
            while (iterator.hasNext()) {
                this.addJIDStatusFire((String)iterator.next(), string, normalJIDStatus);
            }
        }
    }

    private void changeItem(NormalJIDStatus normalJIDStatus, String string, RosterItem rosterItem, JID jID) {
        if (!string.equals(normalJIDStatus.getNick())) {
            this.nickChanges(normalJIDStatus, string, rosterItem, jID);
        }
        if (jID.getUser() == null) {
            normalJIDStatus.update(rosterItem);
        } else if (rosterItem.getGroups() == null) {
            if (normalJIDStatus.groupCount() < 1) {
                normalJIDStatus.update(rosterItem);
            } else if (!normalJIDStatus.isGroupPresent(I18N.gettext("main.main.roster.Unfiled"))) {
                Iterator iterator = normalJIDStatus.getGroups();
                while (iterator.hasNext()) {
                    this.removeJIDStatus((String)iterator.next(), string, normalJIDStatus);
                }
                this.addJIDStatusFire(I18N.gettext("main.main.roster.Unfiled"), string, normalJIDStatus);
                normalJIDStatus.update(rosterItem);
            }
        } else {
            this.changeGroups(normalJIDStatus, string, rosterItem);
        }
    }

    private void nickChanges(NormalJIDStatus normalJIDStatus, String string, RosterItem rosterItem, JID jID) {
        String string2 = normalJIDStatus.getNick();
        if (jID.getUser() == null) {
            this.server.removeServer(string2, normalJIDStatus);
            normalJIDStatus.update(rosterItem);
            this.server.addServer(string, normalJIDStatus);
        } else {
            Iterator iterator;
            if (normalJIDStatus.groupCount() < 1) {
                this.removeJIDStatus(I18N.gettext("main.main.roster.Unfiled"), string2, normalJIDStatus);
            } else {
                iterator = normalJIDStatus.getGroups();
                while (iterator.hasNext()) {
                    this.removeJIDStatus((String)iterator.next(), string2, normalJIDStatus);
                }
            }
            normalJIDStatus.update(rosterItem);
            if (rosterItem.getGroups() == null) {
                this.addJIDStatusFire(I18N.gettext("main.main.roster.Unfiled"), string, normalJIDStatus);
            } else {
                iterator = rosterItem.getGroups().iterator();
                while (iterator.hasNext()) {
                    this.addJIDStatusFire((String)iterator.next(), string, normalJIDStatus);
                }
            }
        }
    }

    private void changeGroups(NormalJIDStatus normalJIDStatus, String string, RosterItem rosterItem) {
        List list = normalJIDStatus.getGroupsCopy();
        Iterator iterator = rosterItem.getGroups().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (list.contains(string2)) {
                list.remove(string2);
                continue;
            }
            this.addJIDStatusFire(string2, string, normalJIDStatus);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            this.removeJIDStatus((String)iterator.next(), string, normalJIDStatus);
        }
        normalJIDStatus.update(rosterItem);
    }

    private void addJIDStatus(String string, JIDStatus jIDStatus) {
        JIDStatusGroup jIDStatusGroup = this.jidTree.getGroup(string);
        PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(jIDStatus.getNick());
        if (primaryJIDStatus == null) {
            primaryJIDStatus = new PrimaryJIDStatus(jIDStatus.getNick(), jIDStatus);
            jIDStatusGroup.addPrimaryJIDStatus(primaryJIDStatus);
        } else {
            primaryJIDStatus.addJIDStatus(jIDStatus);
        }
    }

    private void addJIDStatusFire(String string, String string2, NormalJIDStatus normalJIDStatus) {
        Object object;
        Iterator iterator;
        JIDStatusGroup jIDStatusGroup;
        if (!this.jidTree.existGroup(string)) {
            jIDStatusGroup = this.jidTree.getGroup(string);
            int n = this.jidTree.indexOfGroup(jIDStatusGroup);
            iterator = this.backend.getListeners(RosterListener.class);
            while (iterator.hasNext()) {
                ((RosterListener)iterator.next()).groupAdded(jIDStatusGroup, n);
            }
        } else {
            jIDStatusGroup = this.jidTree.getGroup(string);
        }
        PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(string2);
        iterator = normalJIDStatus.getSecondaryJIDStatussen();
        while (iterator.hasNext()) {
            object = (SecondaryJIDStatus)iterator.next();
            primaryJIDStatus = this.addJIDStatus(string2, jIDStatusGroup, primaryJIDStatus, (SecondaryJIDStatus)object);
        }
        primaryJIDStatus = this.addJIDStatus(string2, jIDStatusGroup, primaryJIDStatus, normalJIDStatus);
        primaryJIDStatus.updatePresence(normalJIDStatus);
        boolean bl = primaryJIDStatus.isOnline();
        primaryJIDStatus.updateOnline();
        if (!bl && primaryJIDStatus.isOnline()) {
            jIDStatusGroup.addOnline();
            object = this.backend.getListeners(RosterListener.class);
            while (object.hasNext()) {
                ((RosterListener)object.next()).groupUpdated(jIDStatusGroup, this.jidTree.indexOfGroup(jIDStatusGroup));
            }
        }
        object = this.backend.getListeners(RosterListener.class);
        while (object.hasNext()) {
            ((RosterListener)object.next()).jidStatussenUpdated(jIDStatusGroup, primaryJIDStatus);
        }
    }

    private PrimaryJIDStatus addJIDStatus(String string, JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus, SecondaryJIDStatus secondaryJIDStatus) {
        if (primaryJIDStatus == null) {
            primaryJIDStatus = new PrimaryJIDStatus(string, secondaryJIDStatus);
            jIDStatusGroup.addPrimaryJIDStatus(primaryJIDStatus);
            int n = jIDStatusGroup.indexOfPrimaryJIDStatus(primaryJIDStatus);
            Iterator iterator = this.backend.getListeners(RosterListener.class);
            while (iterator.hasNext()) {
                ((RosterListener)iterator.next()).primaryAdded(jIDStatusGroup, primaryJIDStatus, n);
            }
        } else {
            primaryJIDStatus.addJIDStatus(secondaryJIDStatus);
        }
        return primaryJIDStatus;
    }

    private void removeJIDStatus(String string, String string2, NormalJIDStatus normalJIDStatus) {
        Object object;
        JIDStatusGroup jIDStatusGroup = this.jidTree.getGroup(string);
        PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(string2);
        boolean bl = primaryJIDStatus.isOnline();
        Iterator iterator = normalJIDStatus.getSecondaryJIDStatussen();
        while (iterator.hasNext()) {
            object = (SecondaryJIDStatus)iterator.next();
            if (!this.removeJIDStatus2((JIDStatus)object, jIDStatusGroup, primaryJIDStatus)) continue;
            if (bl) {
                jIDStatusGroup.removeOnline();
                Iterator iterator2 = this.backend.getListeners(RosterListener.class);
                while (iterator2.hasNext()) {
                    ((RosterListener)iterator2.next()).groupUpdated(jIDStatusGroup, this.jidTree.indexOfGroup(jIDStatusGroup));
                }
            }
            return;
        }
        boolean bl2 = this.removeJIDStatus2(normalJIDStatus, jIDStatusGroup, primaryJIDStatus);
        if (!bl2) {
            primaryJIDStatus.updateOnline();
        }
        if ((bl2 && bl || bl && !primaryJIDStatus.isOnline()) && -1 != this.jidTree.indexOfGroup(jIDStatusGroup)) {
            jIDStatusGroup.removeOnline();
            object = this.backend.getListeners(RosterListener.class);
            while (object.hasNext()) {
                ((RosterListener)object.next()).groupUpdated(jIDStatusGroup, this.jidTree.indexOfGroup(jIDStatusGroup));
            }
        }
        object = this.backend.getListeners(RosterListener.class);
        while (object.hasNext()) {
            ((RosterListener)object.next()).jidStatussenUpdated(jIDStatusGroup, primaryJIDStatus);
        }
    }

    private boolean removeJIDStatus2(JIDStatus jIDStatus, JIDStatusGroup jIDStatusGroup, PrimaryJIDStatus primaryJIDStatus) {
        if (primaryJIDStatus.removeJIDStatus(jIDStatus)) {
            int n = jIDStatusGroup.indexOfPrimaryJIDStatus(primaryJIDStatus);
            jIDStatusGroup.removePrimaryJIDStatus(primaryJIDStatus);
            Iterator iterator = this.backend.getListeners(RosterListener.class);
            while (iterator.hasNext()) {
                ((RosterListener)iterator.next()).primaryDeleted(jIDStatusGroup, primaryJIDStatus, n);
            }
            if (jIDStatusGroup.size() < 1) {
                int n2 = this.jidTree.indexOfGroup(jIDStatusGroup);
                this.jidTree.removeGroup(jIDStatusGroup);
                Iterator iterator2 = this.backend.getListeners(RosterListener.class);
                while (iterator2.hasNext()) {
                    ((RosterListener)iterator2.next()).groupDeleted(jIDStatusGroup, n2);
                }
            }
            return true;
        }
        return false;
    }

    public void presenceChanged(final Presence presence) {
        JID jID = presence.getFrom();
        final NormalJIDStatus normalJIDStatus = (NormalJIDStatus)jidStatussen.get(jID);
        if (normalJIDStatus == null) {
            return;
        }
        if (jID.getUser() == null) {
            normalJIDStatus.updatePresence(presence);
            this.server.showChange(normalJIDStatus);
            return;
        }
        SecondaryJIDStatus secondaryJIDStatus = normalJIDStatus.getSecondaryJIDStatus(jID.getResource());
        boolean bl = false;
        ResourceJIDStatus resourceJIDStatus = null;
        if (presence.getShow() == 7) {
            resourceJIDStatus = normalJIDStatus.removeResource(jID.getResource());
            if (resourceJIDStatus == null && secondaryJIDStatus != null) {
                secondaryJIDStatus.updatePresence(presence);
            }
        } else {
            if (secondaryJIDStatus == null) {
                secondaryJIDStatus = normalJIDStatus.addSecondaryJIDStatus(jID);
                bl = true;
            } else if (secondaryJIDStatus.getShow() == presence.getShow()) {
                if (secondaryJIDStatus.getType().equals("msn") && secondaryJIDStatus.getStatus() != null && Preferences.getBoolean("jeti", "showRealNick", false) && !secondaryJIDStatus.getStatus().equals(presence.getStatus())) {
                    final SecondaryJIDStatus secondaryJIDStatus2 = secondaryJIDStatus;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            secondaryJIDStatus2.updatePresence(presence);
                            Iterator iterator = normalJIDStatus.getGroups();
                            while (iterator.hasNext()) {
                                JIDStatusGroup jIDStatusGroup = Roster.this.jidTree.getGroup((String)iterator.next());
                                PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(normalJIDStatus.getNick());
                                Iterator iterator2 = Roster.this.backend.getListeners(class$nu$fw$jeti$events$RosterListener == null ? Roster.class$("nu.fw.jeti.events.RosterListener") : class$nu$fw$jeti$events$RosterListener);
                                while (iterator2.hasNext()) {
                                    ((RosterListener)iterator2.next()).jidStatussenUpdated(jIDStatusGroup, primaryJIDStatus);
                                }
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                secondaryJIDStatus.updatePresence(presence);
                return;
            }
            secondaryJIDStatus.updatePresence(presence);
            normalJIDStatus.sortSecondary();
        }
        final SecondaryJIDStatus secondaryJIDStatus3 = secondaryJIDStatus;
        final boolean bl2 = bl;
        final ResourceJIDStatus resourceJIDStatus2 = resourceJIDStatus;
        Runnable runnable = new Runnable(){

            public void run() {
                Iterator iterator = normalJIDStatus.getGroups();
                while (iterator.hasNext()) {
                    Iterator iterator2;
                    JIDStatusGroup jIDStatusGroup = Roster.this.jidTree.getGroup((String)iterator.next());
                    PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(normalJIDStatus.getNick());
                    if (bl2) {
                        primaryJIDStatus.addJIDStatus(secondaryJIDStatus3);
                    }
                    if (resourceJIDStatus2 != null) {
                        primaryJIDStatus.removeJIDStatus(resourceJIDStatus2);
                    } else if (secondaryJIDStatus3 != null) {
                        primaryJIDStatus.updatePresence(secondaryJIDStatus3);
                    }
                    boolean bl = primaryJIDStatus.isOnline();
                    primaryJIDStatus.updateOnline();
                    boolean bl22 = primaryJIDStatus.isOnline();
                    if (bl && !bl22) {
                        jIDStatusGroup.removeOnline();
                        iterator2 = Roster.this.backend.getListeners(class$nu$fw$jeti$events$RosterListener == null ? Roster.class$("nu.fw.jeti.events.RosterListener") : class$nu$fw$jeti$events$RosterListener);
                        while (iterator2.hasNext()) {
                            ((RosterListener)iterator2.next()).groupUpdated(jIDStatusGroup, Roster.this.jidTree.indexOfGroup(jIDStatusGroup));
                        }
                    } else if (!bl && bl22) {
                        jIDStatusGroup.addOnline();
                        iterator2 = Roster.this.backend.getListeners(class$nu$fw$jeti$events$RosterListener == null ? Roster.class$("nu.fw.jeti.events.RosterListener") : class$nu$fw$jeti$events$RosterListener);
                        while (iterator2.hasNext()) {
                            ((RosterListener)iterator2.next()).groupUpdated(jIDStatusGroup, Roster.this.jidTree.indexOfGroup(jIDStatusGroup));
                        }
                    }
                    iterator2 = Roster.this.backend.getListeners(class$nu$fw$jeti$events$RosterListener == null ? Roster.class$("nu.fw.jeti.events.RosterListener") : class$nu$fw$jeti$events$RosterListener);
                    while (iterator2.hasNext()) {
                        ((RosterListener)iterator2.next()).jidStatussenUpdated(jIDStatusGroup, primaryJIDStatus);
                    }
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static JIDStatus getJIDStatus(JID jID) {
        return (JIDStatus)jidStatussen.get(jID);
    }

    public static Iterator getJIDStatussen() {
        return jidStatussen.values().iterator();
    }

    public String[] getAllGroups() {
        if (this.jidTree == null) {
            return new String[]{I18N.gettext("main.main.roster.Friends")};
        }
        return this.jidTree.getGroups();
    }
}

