/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui.login;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.XMLDataFile;
import nu.fw.jeti.ui.login.ProfileInfoHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileInfo
extends XMLDataFile {
    private HashMap profiles = new HashMap();

    public ProfileInfo() {
        this(null);
    }

    public ProfileInfo(SAXParser sAXParser) {
        if (sAXParser == null) {
            sAXParser = this.initSax();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(Start.path + "profiles.xml");
        }
        catch (IOException iOException) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(Start.path + "profiles.xml"));
                bufferedWriter.write(this.toString());
                bufferedWriter.close();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
        }
        if (fileInputStream != null) {
            try {
                sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)new ProfileInfoHandler(this.profiles));
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private SAXParser initSax() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return null;
    }

    public Object[] getProfilesList() {
        return this.profiles.keySet().toArray();
    }

    public LoginInfo getProfile(String string) {
        return (LoginInfo)this.profiles.get(string);
    }

    public void setProfile(String string, LoginInfo loginInfo) {
        this.profiles.put(string, loginInfo);
    }

    public void remove(String string) {
        this.profiles.remove(string);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendToXML(stringBuffer);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Start.path + "profiles.xml"), "UTF8"));
            bufferedWriter.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public void appendToXML(StringBuffer stringBuffer) {
        Random random = new Random();
        this.appendHeader(stringBuffer);
        this.appendOpenTag(stringBuffer, "<profiles>");
        Iterator iterator = this.profiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            LoginInfo loginInfo = (LoginInfo)entry.getValue();
            this.appendOpenTag(stringBuffer, "<profile");
            this.appendAttribute(stringBuffer, "name", string);
            this.appendAttribute(stringBuffer, "server", loginInfo.getServer());
            String string2 = loginInfo.getPassword();
            if (string2 != null) {
                this.appendAttribute(stringBuffer, "password", this.encrypt(string2, random));
            }
            this.appendAttribute(stringBuffer, "username", loginInfo.getUsername());
            this.appendAttribute(stringBuffer, "resource", loginInfo.getResource());
            this.appendAttribute(stringBuffer, "port", Integer.toString(loginInfo.getPort()));
            this.appendAttribute(stringBuffer, "host", loginInfo.getHost());
            this.appendAttribute(stringBuffer, "ssl", Boolean.toString(loginInfo.isSSl()));
            this.appendAttribute(stringBuffer, "priority", Integer.toString(loginInfo.getPriority()));
            this.appendAttribute(stringBuffer, "hideStatusWindow", Boolean.toString(loginInfo.hideStatusWindow()));
            if (!loginInfo.useProxy(0)) {
                stringBuffer.append('>');
                this.appendOpenTag(stringBuffer, "<proxy");
                this.appendAttribute(stringBuffer, "proxyType", Integer.toString(loginInfo.getProxyType()));
                this.appendAttribute(stringBuffer, "proxyServer", loginInfo.getProxyServer());
                this.appendAttribute(stringBuffer, "proxyUsername", loginInfo.getProxyUsername());
                string2 = loginInfo.getProxyPassword();
                if (string2 != null && !string2.equals("")) {
                    this.appendAttribute(stringBuffer, "proxyPassword", this.encrypt(string2, random));
                }
                this.appendAttribute(stringBuffer, "proxyPort", loginInfo.getProxyPort());
                this.appendCloseSymbol(stringBuffer);
                this.appendCloseTag(stringBuffer, "</profile>");
                continue;
            }
            this.appendCloseSymbol(stringBuffer);
        }
        this.appendCloseTag(stringBuffer, "</profiles>");
    }

    private String encrypt(String string, Random random) {
        int n = random.nextInt(65536);
        random.setSeed(n);
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "0000".concat(Integer.toHexString(n));
        string2 = string2.substring(string2.length() - 4, string2.length());
        stringBuffer.append(string2.substring(0, 2));
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            String string3 = "0000".concat(Integer.toHexString(c + random.nextInt(100)));
            stringBuffer.append(string3.substring(string3.length() - 4, string3.length()));
        }
        stringBuffer.append(string2.substring(2, 4));
        return stringBuffer.toString();
    }
}

