/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.filetransfer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XDataBuilder;
import nu.fw.jeti.jabber.elements.XDataField;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;
import nu.fw.jeti.plugins.filetransfer.IQSi;
import nu.fw.jeti.plugins.filetransfer.Plugin;
import nu.fw.jeti.plugins.filetransfer.StreamReceive;
import nu.fw.jeti.plugins.filetransfer.XSiFileTransfer;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.Utils;

public class GetFileWindow
extends JFrame {
    private JProgressBar progressBar = new JProgressBar();
    private JButton btnDownload = new JButton();
    private JButton btnCancel = new JButton();
    private Backend backend;
    private String streamMethod;
    private InfoQuery iq;
    private OutputStream out;
    private Timer timer;
    private StreamReceive streamReceive;
    private String fromName;
    private String fileName;
    private long fileSize;
    private String description;
    private int ibbMaxSize = Preferences.getInteger((String)"filetransfer", (String)"ibbMaxSize", (int)4096);

    public GetFileWindow(Backend backend, InfoQuery iq) {
        this.iq = iq;
        this.backend = backend;
        if (this.init()) {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }

    private boolean init() {
        Iterator j;
        IQSi iqSi = (IQSi)this.iq.getIQExtension();
        ArrayList<Object> streamOptions = new ArrayList<Object>();
        XData data = iqSi.getXDataForm();
        if (data.hasFields()) {
            Iterator i = data.getFields();
            while (i.hasNext()) {
                XDataField datafield = (XDataField)i.next();
                if (!"stream-method".equals(datafield.getVar()) || !datafield.hasOptions()) continue;
                j = datafield.getOptionsIterator();
                while (j.hasNext()) {
                    streamOptions.add(((Object[])j.next())[1]);
                }
            }
        }
        String value = null;
        XSiFileTransfer sifi = iqSi.getSiprofile();
        if (sifi != null) {
            if (streamOptions.contains("http://jabber.org/protocol/bytestreams") && Preferences.getBoolean((String)"filetransfer", (String)"bytestreams.enable", (boolean)true)) {
                value = "http://jabber.org/protocol/bytestreams";
            }
            if (sifi.getSize() < (long)this.ibbMaxSize && Preferences.getBoolean((String)"filetransfer", (String)"ibb.enable", (boolean)true) && streamOptions.contains("http://jabber.org/protocol/ibb")) {
                value = "http://jabber.org/protocol/ibb";
            }
            if (value == null) {
                XMPPError error = new XMPPError("cancel", 400);
                error.addError(new XMPPErrorTag("bad-request"));
                error.addError(new XMPPErrorTag("no-valid-streams", "http://jabber.org/protocol/si"));
                this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), this.iq.getID(), error));
                return false;
            }
            this.streamMethod = value;
            j = Backend.getJIDStatus((JID)this.iq.getFrom());
            this.fromName = j == null ? this.iq.getFrom().toString() : j.getNick();
            this.fileName = sifi.getName();
            this.fileSize = sifi.getSize();
            this.progressBar.setMaximum((int)(this.fileSize / 1024L));
            this.description = sifi.getDescription();
        }
        return true;
    }

    private void jbInit() {
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.setTitle(I18N.gettext((String)"filetransfer.File_Transfer"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.anchor = 21;
        c.fill = 1;
        c.insets = new Insets(3, 5, 0, 3);
        GridBagConstraints c2 = (GridBagConstraints)c.clone();
        c2.gridwidth = 0;
        c2.weightx = 1.0;
        JLabel lbl = new JLabel(I18N.gettext((String)"filetransfer.From"));
        this.getContentPane().add((Component)lbl, c);
        lbl = new JLabel(this.fromName);
        this.getContentPane().add((Component)lbl, c2);
        lbl = new JLabel(I18N.gettext((String)"filetransfer.File_Name"));
        this.getContentPane().add((Component)lbl, c);
        lbl = new JLabel(this.fileName);
        this.getContentPane().add((Component)lbl, c2);
        lbl = new JLabel(I18N.gettext((String)"filetransfer.File_Size"));
        this.getContentPane().add((Component)lbl, c);
        lbl = new JLabel(Plugin.getSizeText(this.fileSize));
        this.getContentPane().add((Component)lbl, c2);
        if (this.description != null && this.description.length() > 0) {
            lbl = new JLabel(I18N.gettext((String)"filetransfer.Description"));
            this.getContentPane().add((Component)lbl, c);
            JTextArea d = new JTextArea(this.description);
            d.setEditable(false);
            this.getContentPane().add((Component)new JScrollPane(d), c2);
        }
        c2.anchor = 10;
        this.progressBar.setPreferredSize(new Dimension(300, 17));
        this.getContentPane().add((Component)this.progressBar, c2);
        c2.fill = 0;
        JPanel panel = new JPanel();
        this.btnDownload.setText(I18N.gettext((String)"filetransfer.Download"));
        this.getRootPane().setDefaultButton(this.btnDownload);
        this.btnDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GetFileWindow.this.btnDownload_actionPerformed(e);
            }
        });
        AbstractAction cancelAction = new AbstractAction(I18N.gettext((String)"Cancel")){

            public void actionPerformed(ActionEvent e) {
                GetFileWindow.this.btnCancel_actionPerformed(e);
            }
        };
        Utils.addCancelButton((RootPaneContainer)this, (JButton)this.btnCancel, (Action)cancelAction);
        panel.add(this.btnDownload);
        panel.add(this.btnCancel);
        this.getContentPane().add((Component)panel, c2);
    }

    void btnDownload_actionPerformed(ActionEvent e) {
        int opt;
        JFileChooser fileChooser = Plugin.getFileChooser();
        fileChooser.setDialogTitle("Save " + this.fileName);
        String dir = Preferences.getString((String)"filetransfer", (String)"downloadDir", null);
        if (dir != null) {
            fileChooser.setCurrentDirectory(new File(dir));
        }
        fileChooser.setSelectedFile(new File(this.fileName));
        int a = fileChooser.showSaveDialog(this.backend.getMainWindow());
        if (a != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        Preferences.putString((String)"filetransfer", (String)"downloadDir", (String)file.getParent());
        if (file.exists() && (opt = JOptionPane.showConfirmDialog(this, MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_already_exist,_overwrite?"), file.toString()), I18N.gettext((String)"filetransfer.File_Transfer"), 0, 2)) == 1) {
            return;
        }
        try {
            this.out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e2) {
            Popups.errorPopup((String)MessageFormat.format(I18N.gettext((String)"filetransfer.{0}_could_not_be_openend_in_write_mode"), file.getAbsolutePath()), (String)I18N.gettext((String)"filetransfer.File_Transfer"));
            return;
        }
        XDataBuilder xdb = new XDataBuilder();
        xdb.type = "submit";
        xdb.addField(new XDataField("stream-method", this.streamMethod));
        XData xdata = null;
        try {
            xdata = xdb.build();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), "result", this.iq.getID(), (IQExtension)new IQSi(xdata, null)));
        IQSi iqSi = (IQSi)this.iq.getIQExtension();
        Plugin.addGetFile(this, this.iq.getFrom(), iqSi.getId());
        this.fileName = file.getName();
        this.btnDownload.setEnabled(false);
    }

    void btnCancel_actionPerformed(ActionEvent e) {
        if (this.btnCancel.getText().equals(I18N.gettext((String)"filetransfer.Close"))) {
            this.dispose();
        } else if (this.streamReceive != null) {
            this.timer.stop();
            this.streamReceive.cancel();
        } else {
            XMPPError error = new XMPPError("cancel", 403);
            error.addError(new XMPPErrorTag("forbidden"));
            this.backend.send((Packet)new InfoQuery(this.iq.getFrom(), this.iq.getID(), error));
        }
        this.dispose();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public StreamReceive getStreamReceive() {
        return this.streamReceive;
    }

    public void startDownloading(StreamReceive receive) {
        this.streamReceive = receive;
        this.initTimer();
    }

    private void initTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                long bytes = GetFileWindow.this.streamReceive.getBytes();
                GetFileWindow.this.progressBar.setValue((int)(bytes / 1024L));
                int percent = (int)((double)bytes / (double)GetFileWindow.this.fileSize * 100.0);
                GetFileWindow.this.setTitle(String.valueOf(percent) + "% " + GetFileWindow.this.fileName);
            }
        });
        this.timer.start();
    }

    public void stopDownloading() {
        if (Preferences.getBoolean((String)"filetransfer", (String)"closeOnComplete", (boolean)false)) {
            this.dispose();
        } else {
            this.btnCancel.setText(I18N.gettext((String)"filetransfer.Close"));
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.setTitle("100% " + this.fileName);
        }
        this.timer.stop();
    }
}

