/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.elements;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import net.sourceforge.retroweaver.runtime.java.lang.Long_;
import nu.fw.jeti.backend.XExecutableExtension;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.drawing.Plugin;
import nu.fw.jeti.plugins.drawing.elements.PictureMessageBuilder;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.util.Log;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PictureMessage
extends Extension
implements XExecutableExtension {
    protected List<Long> shapeIdList;
    protected String actionsAuthor;
    protected String thread;
    protected String subject;
    protected String time;
    protected int counter;
    private JID to;
    public static final String SHAPE_ID_TAG = "shapeId";
    public static final String ACTIONS_AUTHOR_TAG = "actions_author";
    public static final String THREAD_TAG = "thread";
    public static final String SUBJECT_TAG = "subject";
    public static final String COLOR_TAG = "color";
    public static final String TIME_TAG = "time";
    public static final String COUNTER_TAG = "counter";
    public static final String MESSAGE_TAG = "message";
    public static final String DRAW_MESSAGE_TAG = "draw_mess";

    public PictureMessage(PictureMessageBuilder pictureMessageBuilder) {
        this.shapeIdList = this.stringToLongList(pictureMessageBuilder.shapeIdList);
        this.actionsAuthor = pictureMessageBuilder.actionsAuthor;
        this.thread = pictureMessageBuilder.thread;
        this.subject = pictureMessageBuilder.subject;
        this.time = pictureMessageBuilder.time;
        this.counter = Integer.parseInt(pictureMessageBuilder.counter);
    }

    public PictureMessage(JID jID, String string, List<Long> list, String string2, String string3, int n) {
        this.actionsAuthor = string;
        this.shapeIdList = list;
        this.time = string3;
        this.counter = n;
        this.to = jID;
        this.thread = string2;
    }

    public static Color stringToColor(String string) {
        String[] stringArray = string.split(" ");
        return new Color(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    public static String colorToString(Color color) {
        return new StringBuffer().append(color.getRed()).append(" ").append(color.getGreen()).append(" ").append(color.getBlue()).append(" ").append(color.getAlpha()).toString();
    }

    protected List<Long> stringToLongList(String string) {
        if (string != null && !string.equals("")) {
            String[] stringArray = string.split("\\s");
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(Long_.valueOf((long)Long.parseLong(stringArray[i])));
            }
            return arrayList;
        }
        return null;
    }

    protected JID stringToJID(String string) {
        JID jID = null;
        try {
            jID = JID.checkedJIDFromString((String)string);
        }
        catch (InstantiationException instantiationException) {
            Log.notParsedXML((String)new StringBuffer().append("CreationMessage: Shape's author is not JID, but ").append(string).toString());
        }
        return jID;
    }

    public void execute(Packet packet, Backend backend) {
        PictureChat pictureChat = Plugin.getPictureChat(packet.getFrom(), this.getThread());
        pictureChat.newMessage(this);
    }

    protected void startAppendingToXML(StringBuffer stringBuffer, String string) {
        this.startAppendingToXMLWithoutShapeId(stringBuffer, string);
        PictureMessage.appendElement((StringBuffer)stringBuffer, (String)SHAPE_ID_TAG, (String)this.longListToString(this.shapeIdList));
    }

    protected void startAppendingToXMLWithoutShapeId(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<data xmlns= 'http://jeti.sf.net/protocol/whiteboard'");
        PictureMessage.appendAttribute((StringBuffer)stringBuffer, (String)DRAW_MESSAGE_TAG, (String)"true");
        PictureMessage.appendAttribute((StringBuffer)stringBuffer, (String)TIME_TAG, (String)this.time);
        PictureMessage.appendAttribute((StringBuffer)stringBuffer, (String)COUNTER_TAG, (Object)Integer_.valueOf((int)this.counter));
        stringBuffer.append(">");
        PictureMessage.appendElement((StringBuffer)stringBuffer, (String)THREAD_TAG, (String)this.thread);
        PictureMessage.appendElement((StringBuffer)stringBuffer, (String)ACTIONS_AUTHOR_TAG, (String)this.actionsAuthor);
        stringBuffer.append(new StringBuffer().append("<").append(string).append(">").toString());
    }

    private String longListToString(List<Long> list) {
        String string = "";
        if (list != null) {
            for (Long l : list) {
                string = new StringBuffer().append(string).append(l).append(" ").toString();
            }
        }
        return string;
    }

    protected void endAppendingToXML(StringBuffer stringBuffer, String string) {
        stringBuffer.append(new StringBuffer().append("</").append(string).append(">").toString());
        stringBuffer.append("</data>");
    }

    public List<Long> getShapeIdList() {
        return this.shapeIdList;
    }

    public String getActionsAuthor() {
        return this.actionsAuthor;
    }

    public String getThread() {
        return this.thread;
    }

    public JID getTo() {
        return this.to;
    }

    public int getCounter() {
        return this.counter;
    }

    public String getTime() {
        return this.time;
    }
}

