/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.drawing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.drawing.shapes.PictureChat;
import nu.fw.jeti.plugins.drawing.shapes.PicturesContent;
import nu.fw.jeti.plugins.drawing.ui.AddUsersSelectAction;
import nu.fw.jeti.plugins.drawing.ui.BackgroundColorSettingAction;
import nu.fw.jeti.plugins.drawing.ui.BlockChatAction;
import nu.fw.jeti.plugins.drawing.ui.Board;
import nu.fw.jeti.plugins.drawing.ui.ChangeModeAction;
import nu.fw.jeti.plugins.drawing.ui.ClearAction;
import nu.fw.jeti.plugins.drawing.ui.ColorSelectAction;
import nu.fw.jeti.plugins.drawing.ui.CopySelectAction;
import nu.fw.jeti.plugins.drawing.ui.CutSelectAction;
import nu.fw.jeti.plugins.drawing.ui.DeleteSelectAction;
import nu.fw.jeti.plugins.drawing.ui.EllipseMode;
import nu.fw.jeti.plugins.drawing.ui.ExitListener;
import nu.fw.jeti.plugins.drawing.ui.FilledPolylineMode;
import nu.fw.jeti.plugins.drawing.ui.FontSelectAction;
import nu.fw.jeti.plugins.drawing.ui.HistoryPanel;
import nu.fw.jeti.plugins.drawing.ui.LineMode;
import nu.fw.jeti.plugins.drawing.ui.Mode;
import nu.fw.jeti.plugins.drawing.ui.PasteSelectAction;
import nu.fw.jeti.plugins.drawing.ui.PictureFileFilter;
import nu.fw.jeti.plugins.drawing.ui.PolygonMode;
import nu.fw.jeti.plugins.drawing.ui.PolylineMode;
import nu.fw.jeti.plugins.drawing.ui.RectangleMode;
import nu.fw.jeti.plugins.drawing.ui.RedoSelectAction;
import nu.fw.jeti.plugins.drawing.ui.SelectAllAction;
import nu.fw.jeti.plugins.drawing.ui.SelectionMode;
import nu.fw.jeti.plugins.drawing.ui.ShapeColorSettingAction;
import nu.fw.jeti.plugins.drawing.ui.ShowHideHistorytAction;
import nu.fw.jeti.plugins.drawing.ui.TransparencySettingAction;
import nu.fw.jeti.plugins.drawing.ui.UndoSelectAction;
import nu.fw.jeti.plugins.drawing.ui.UserRepresentation;
import nu.fw.jeti.plugins.drawing.ui.WritingMode;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PictureChatFrame
extends JFrame {
    private Board board;
    private PictureChat chat;
    private Vector<Mode> drawingModes;
    private JFileChooser fileChooser;
    private File file;
    private ButtonGroup buttonGroup;
    private HistoryPanel historyPanel;
    JScrollPane pane;
    private static final long serialVersionUID = -8019354910612112821L;
    private static final int PICTURE_WIDTH = 640;
    private static final int PICTURE_HEIGHT = 480;

    public PictureChatFrame(PictureChat pictureChat, PicturesContent picturesContent, HistoryPanel historyPanel) {
        this.setDefaultCloseOperation(2);
        this.setIconImage(StatusIcons.getImageIcon((String)"jeti").getImage());
        this.chat = pictureChat;
        this.historyPanel = historyPanel;
        this.buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = this.createBoardAndHistory(picturesContent);
        this.addMenuAndToolBar(jPanel);
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void createDrawingModes() {
        this.drawingModes = new Vector();
        this.drawingModes.add(new PolylineMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Pen"), new ImageIcon(this.getClass().getResource("images/Pen24.png")), I18N.getText((String)"drawing", (String)"Pen"), new Integer(80)));
        this.drawingModes.add(new LineMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Line"), new ImageIcon(this.getClass().getResource("images/Line24.png")), I18N.getText((String)"drawing", (String)"Line"), new Integer(76)));
        this.drawingModes.add(new FilledPolylineMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Filled_Polyline"), new ImageIcon(this.getClass().getResource("images/FilledPolyline24.png")), I18N.getText((String)"drawing", (String)"Filled_Polyline"), new Integer(73)));
        this.drawingModes.add(new RectangleMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Rectangle"), new ImageIcon(this.getClass().getResource("images/Rectangle24.png")), I18N.getText((String)"drawing", (String)"Rectangle"), new Integer(84), false));
        this.drawingModes.add(new RectangleMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Filled_Rectangle"), new ImageIcon(this.getClass().getResource("images/FilledRectangle24.png")), I18N.getText((String)"drawing", (String)"Filled_Rectangle"), new Integer(71), true));
        this.drawingModes.add(new EllipseMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Ellipse"), new ImageIcon(this.getClass().getResource("images/Ellipse24.png")), I18N.getText((String)"drawing", (String)"Ellipse"), new Integer(69), false));
        this.drawingModes.add(new EllipseMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Filled_Ellipse"), new ImageIcon(this.getClass().getResource("images/FilledEllipse24.png")), I18N.getText((String)"drawing", (String)"Filled_Ellipse"), new Integer(76), true));
        this.drawingModes.add(new PolygonMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Polygon"), new ImageIcon(this.getClass().getResource("images/Polygon24.png")), I18N.getText((String)"drawing", (String)"Polygon"), null, false));
        this.drawingModes.add(new PolygonMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Filled_Polygon"), new ImageIcon(this.getClass().getResource("images/FilledPolygon24.png")), I18N.getText((String)"drawing", (String)"Filled_Polygon"), null, true));
        this.drawingModes.add(new WritingMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Write"), new ImageIcon(this.getClass().getResource("images/Font24.png")), I18N.getText((String)"drawing", (String)"Write"), null));
    }

    private void addMenuAndToolBar(JPanel jPanel) {
        JMenuBar jMenuBar = new JMenuBar();
        JToolBar jToolBar = new JToolBar();
        JMenu jMenu = this.createFileMenu(jToolBar);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = this.createEditMenu(jToolBar);
        jMenuBar.add(jMenu2);
        JToolBar jToolBar2 = new JToolBar();
        JMenu jMenu3 = this.createDrawMenu(jToolBar2);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = this.createFontAndColorMenu(jToolBar2);
        jMenuBar.add(jMenu4);
        JMenu jMenu5 = this.createChatMenu(jToolBar);
        jMenuBar.add(jMenu5);
        jPanel.add(jToolBar);
        jPanel.add(jToolBar2);
        this.setJMenuBar(jMenuBar);
    }

    private JMenuItem createMenuItem(Action action) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setIcon(null);
        return jMenuItem;
    }

    private JToggleButton createButtonToToolBar(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        jToggleButton.setText("");
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup.add(jToggleButton);
        return jToggleButton;
    }

    private JMenu createChatMenu(JToolBar jToolBar) {
        JMenu jMenu = new JMenu(I18N.getText((String)"drawing", (String)"Chat"));
        jMenu.setMnemonic(65);
        AddUsersSelectAction addUsersSelectAction = new AddUsersSelectAction(I18N.getText((String)"drawing", (String)"Add_users_from_roster"), new ImageIcon(this.getClass().getResource("images/AddUsers24.png")), I18N.getText((String)"drawing", (String)"Add_users_to_the_chat"), new Integer(68), this.chat);
        jMenu.add(this.createMenuItem(addUsersSelectAction));
        JMenuItem jMenuItem = new JMenuItem(I18N.getText((String)"drawing", (String)"Add_user"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(I18N.getText((String)"drawing", (String)"Add_users_JID"));
                JID jID = null;
                try {
                    jID = JID.checkedJIDFromString((String)string);
                }
                catch (InstantiationException instantiationException) {
                    Popups.errorPopup((String)instantiationException.getMessage(), (String)I18N.getText((String)"drawing", (String)"Add_users_JID"));
                }
                HashSet<UserRepresentation> hashSet = new HashSet<UserRepresentation>();
                hashSet.add(new UserRepresentation(jID));
                if (jID != null) {
                    PictureChatFrame.this.chat.addUsers(hashSet);
                }
            }
        });
        jMenu.add(jMenuItem);
        jToolBar.add(this.createButtonToToolBar(addUsersSelectAction));
        BlockChatAction blockChatAction = new BlockChatAction(I18N.getText((String)"drawing", (String)"Block_chat"), new ImageIcon(this.getClass().getResource("images/BlockChat24.png")), I18N.getText((String)"drawing", (String)"Block_this_chat_(_you_will_receive_no_more_messages_)"), null, this.chat, this);
        jMenu.add(this.createMenuItem(blockChatAction));
        jToolBar.add(this.createButtonToToolBar(blockChatAction));
        ShowHideHistorytAction showHideHistorytAction = new ShowHideHistorytAction(I18N.getText((String)"drawing", (String)"Show_/_hide_history"), new ImageIcon(this.getClass().getResource("images/History24.png")), I18N.getText((String)"drawing", (String)"Show_/_hide_history"), null, this.historyPanel, this);
        jMenu.add(this.createMenuItem(showHideHistorytAction));
        jToolBar.add(this.createButtonToToolBar(showHideHistorytAction));
        return jMenu;
    }

    private void addModeToMenus(Mode mode, JMenu jMenu, JToolBar jToolBar) {
        ChangeModeAction changeModeAction = new ChangeModeAction(mode);
        JMenuItem jMenuItem = new JMenuItem(changeModeAction);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        JToggleButton jToggleButton = new JToggleButton(changeModeAction);
        jToggleButton.setText("");
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup.add(jToggleButton);
        jToolBar.add(jToggleButton);
    }

    private JMenu createDrawMenu(JToolBar jToolBar) {
        JMenu jMenu = new JMenu(I18N.getText((String)"drawing", (String)"Draw"));
        jMenu.setMnemonic(68);
        for (Mode mode : this.drawingModes) {
            this.addModeToMenus(mode, jMenu, jToolBar);
        }
        return jMenu;
    }

    private JMenu createFontAndColorMenu(JToolBar jToolBar) {
        JMenu jMenu = new JMenu(I18N.getText((String)"drawing", (String)"Font_and_color"));
        jMenu.setMnemonic(67);
        ColorSelectAction colorSelectAction = new ColorSelectAction(I18N.getText((String)"drawing", (String)"Color"), new ImageIcon(this.getClass().getResource("images/Colors24.png")), I18N.getText((String)"drawing", (String)"Choose_a_color"), new Integer(75), this, this.board);
        jMenu.add(this.createMenuItem(colorSelectAction));
        jToolBar.add(this.createButtonToToolBar(colorSelectAction));
        ShapeColorSettingAction shapeColorSettingAction = new ShapeColorSettingAction(I18N.getText((String)"drawing", (String)"Set_shapes_color"), new ImageIcon(this.getClass().getResource("images/SetShapesColor24.png")), I18N.getText((String)"drawing", (String)"Set_selected_shapes_color"), null, this, this.chat, this.board);
        JMenuItem jMenuItem = this.createMenuItem(shapeColorSettingAction);
        jMenu.add(jMenuItem);
        jToolBar.add(this.createButtonToToolBar(shapeColorSettingAction));
        BackgroundColorSettingAction backgroundColorSettingAction = new BackgroundColorSettingAction(I18N.getText((String)"drawing", (String)"Background_color"), null, I18N.getText((String)"drawing", (String)"Set_background_color"), null, this, this.chat, this.board);
        jMenu.add(this.createMenuItem(backgroundColorSettingAction));
        TransparencySettingAction transparencySettingAction = new TransparencySettingAction(I18N.getText((String)"drawing", (String)"Set_colors_transparency"), null, I18N.getText((String)"drawing", (String)"Set_colors_transparency"), null, this, this.board);
        jMenu.add(this.createMenuItem(transparencySettingAction));
        jMenu.addSeparator();
        FontSelectAction fontSelectAction = new FontSelectAction(I18N.getText((String)"drawing", (String)"Choose_font"), null, I18N.getText((String)"drawing", (String)"Choose_font"), null, this, this.board);
        jMenu.add(this.createMenuItem(fontSelectAction));
        return jMenu;
    }

    private JMenu createEditMenu(JToolBar jToolBar) {
        JMenu jMenu = new JMenu(I18N.getText((String)"drawing", (String)"Edit"));
        jMenu.setMnemonic(69);
        UndoSelectAction undoSelectAction = new UndoSelectAction(I18N.getText((String)"drawing", (String)"Undo"), new ImageIcon(this.getClass().getResource("images/Undo24.png")), I18N.getText((String)"drawing", (String)"Undo"), new Integer(85), this.chat);
        JMenuItem jMenuItem = this.createMenuItem(undoSelectAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        jMenu.add(jMenuItem);
        jToolBar.add(this.createButtonToToolBar(undoSelectAction));
        RedoSelectAction redoSelectAction = new RedoSelectAction(I18N.getText((String)"drawing", (String)"Redo"), new ImageIcon(this.getClass().getResource("images/Redo24.png")), I18N.getText((String)"drawing", (String)"Redo"), new Integer(82), this.chat);
        JMenuItem jMenuItem2 = this.createMenuItem(redoSelectAction);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        jMenu.add(jMenuItem2);
        jToolBar.add(this.createButtonToToolBar(redoSelectAction));
        jMenu.addSeparator();
        CutSelectAction cutSelectAction = new CutSelectAction(I18N.getText((String)"drawing", (String)"Cut"), new ImageIcon(this.getClass().getResource("images/Cut24.gif")), I18N.getText((String)"drawing", (String)"Cut"), new Integer(88), this.chat);
        JMenuItem jMenuItem3 = this.createMenuItem(cutSelectAction);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenu.add(jMenuItem3);
        jToolBar.add(this.createButtonToToolBar(cutSelectAction));
        CopySelectAction copySelectAction = new CopySelectAction(I18N.getText((String)"drawing", (String)"Copy"), new ImageIcon(this.getClass().getResource("images/Copy24.gif")), I18N.getText((String)"drawing", (String)"Copy"), new Integer(67), this.chat);
        JMenuItem jMenuItem4 = this.createMenuItem(copySelectAction);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenu.add(jMenuItem4);
        jToolBar.add(this.createButtonToToolBar(copySelectAction));
        PasteSelectAction pasteSelectAction = new PasteSelectAction(I18N.getText((String)"drawing", (String)"Paste"), new ImageIcon(this.getClass().getResource("images/Paste24.gif")), I18N.getText((String)"drawing", (String)"Paste"), new Integer(80), this.chat);
        JMenuItem jMenuItem5 = this.createMenuItem(pasteSelectAction);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenu.add(jMenuItem5);
        jToolBar.add(this.createButtonToToolBar(pasteSelectAction));
        jMenu.addSeparator();
        SelectionMode selectionMode = new SelectionMode(this.chat, this.board, I18N.getText((String)"drawing", (String)"Select"), new ImageIcon(this.getClass().getResource("images/Select24.png")), I18N.getText((String)"drawing", (String)"Select"), new Integer(84));
        this.addModeToMenus(selectionMode, jMenu, jToolBar);
        SelectAllAction selectAllAction = new SelectAllAction(I18N.getText((String)"drawing", (String)"Select_all"), null, I18N.getText((String)"drawing", (String)"Select_all"), new Integer(65), this.chat);
        JMenuItem jMenuItem6 = this.createMenuItem(selectAllAction);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenu.add(jMenuItem6);
        DeleteSelectAction deleteSelectAction = new DeleteSelectAction(I18N.getText((String)"drawing", (String)"Delete"), new ImageIcon(this.getClass().getResource("images/Remove24.gif")), I18N.getText((String)"drawing", (String)"Delete_selected_shapes"), new Integer(78), this.chat);
        JMenuItem jMenuItem7 = this.createMenuItem(deleteSelectAction);
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jMenu.add(jMenuItem7);
        jToolBar.add(this.createButtonToToolBar(deleteSelectAction));
        ClearAction clearAction = new ClearAction(I18N.getText((String)"drawing", (String)"Clear_picture"), new ImageIcon(this.getClass().getResource("images/New24.gif")), I18N.getText((String)"drawing", (String)"Clear_picture"), null, this.chat);
        jMenu.add(this.createMenuItem(clearAction));
        jToolBar.add(this.createButtonToToolBar(clearAction));
        return jMenu;
    }

    private JMenu createFileMenu(JToolBar jToolBar) {
        JMenu jMenu = new JMenu(I18N.getText((String)"drawing", (String)"File"));
        jMenu.setMnemonic(70);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new PictureFileFilter());
        SaveSelectAction saveSelectAction = new SaveSelectAction(I18N.getText((String)"drawing", (String)"Save"), new ImageIcon(this.getClass().getResource("images/Save24.gif")), I18N.getText((String)"drawing", (String)"Save_picture"), new Integer(83), this.chat);
        JMenuItem jMenuItem = this.createMenuItem(saveSelectAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(jMenuItem);
        jToolBar.add(this.createButtonToToolBar(saveSelectAction));
        SaveAsSelectAction saveAsSelectAction = new SaveAsSelectAction(I18N.getText((String)"drawing", (String)"Save_as"), null, I18N.getText((String)"drawing", (String)"Save_picture_as"), null);
        jMenu.add(this.createMenuItem(saveAsSelectAction));
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(I18N.getText((String)"drawing", (String)"Exit"), 88);
        jMenuItem2.addActionListener(new ExitListener(this));
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    private JPanel createBoardAndHistory(PicturesContent picturesContent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.board = new Board(this.chat, picturesContent);
        this.createDrawingModes();
        this.board.setCurrentMode(this.drawingModes.firstElement());
        this.board.setPreferredSize(new Dimension(640, 480));
        jPanel.add((Component)this.board, "Center");
        jPanel.add((Component)this.historyPanel, "East");
        return jPanel;
    }

    public void setColor(Color color) {
        this.board.setCurrentColor(color);
    }

    public void setCurrentUsers(List<JID> list) {
        String string = "";
        for (JID jID : list) {
            string = new StringBuffer().append(string).append(new UserRepresentation(jID).toString()).append("; ").toString();
        }
        if (string.length() >= 2) {
            string = string.substring(0, string.length() - 2);
        }
        this.setTitle(string);
    }

    public Color getCurrentBackgroundColor() {
        return this.board.getCurrentBackgroundColor();
    }

    private void saveFromChosenFile() {
        int n = this.fileChooser.showSaveDialog(this);
        if (n == 0) {
            this.file = this.fileChooser.getSelectedFile();
            if (!PictureFileFilter.hasGoodExtension(this.file)) {
                File file;
                this.file = file = PictureFileFilter.getProperFile(this.file);
            }
            this.saveFile(this.chat);
        }
    }

    private void saveFile(PictureChat pictureChat) {
        pictureChat.savePicture(this.file, 640, 480);
    }

    class SaveAsSelectAction
    extends AbstractAction {
        private static final long serialVersionUID = 2866204072140697073L;

        public SaveAsSelectAction(String string, ImageIcon imageIcon, String string2, Integer n) {
            super(string, imageIcon);
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PictureChatFrame.this.saveFromChosenFile();
        }
    }

    class SaveSelectAction
    extends AbstractAction {
        private static final long serialVersionUID = -904437773631661235L;
        private PictureChat chat;

        public SaveSelectAction(String string, ImageIcon imageIcon, String string2, Integer n, PictureChat pictureChat) {
            super(string, imageIcon);
            this.chat = pictureChat;
            this.putValue("ShortDescription", string2);
            this.putValue("MnemonicKey", n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PictureChatFrame.this.file == null) {
                PictureChatFrame.this.saveFromChosenFile();
            } else {
                PictureChatFrame.this.saveFile(this.chat);
            }
        }
    }
}

