/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp;

import java.security.GeneralSecurityException;
import java.util.Map;
import mil.jfcom.cie.media.srtp.BaseStream;
import mil.jfcom.cie.media.srtp.SSRC;

public abstract class BaseProcessor {
    private final Map streamMap;

    public BaseProcessor(Map streamMap) {
        this.streamMap = streamMap;
    }

    public abstract int process(byte[] var1, int var2, int var3, byte[] var4, int var5) throws GeneralSecurityException;

    protected abstract BaseStream createProcessor() throws GeneralSecurityException;

    protected int processStream(byte[] inPacket, int offset, int length, byte[] processedPacket, int outOffset, int posSSRC) throws GeneralSecurityException {
        int len;
        boolean isNewSSRC;
        SSRC ssrc = new SSRC(inPacket, posSSRC + offset);
        BaseStream streamProcessor = (BaseStream)this.streamMap.get(ssrc);
        boolean bl = isNewSSRC = streamProcessor == null;
        if (isNewSSRC) {
            streamProcessor = this.createProcessor();
            len = streamProcessor.process(inPacket, offset, length, processedPacket, outOffset);
            if (len > 0) {
                this.streamMap.put(ssrc, streamProcessor);
            }
        } else {
            len = streamProcessor.process(inPacket, offset, length, processedPacket, outOffset);
        }
        return len;
    }
}

