/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import mil.jfcom.cie.media.srtp.BaseProcessor;
import mil.jfcom.cie.media.srtp.BaseStream;
import mil.jfcom.cie.media.srtp.SRTPUtil;
import mil.jfcom.cie.media.srtp.control.SRTCPReceiveStream;
import mil.jfcom.cie.media.srtp.control.SRTCPSendStream;
import mil.jfcom.cie.media.srtp.data.SRTPReceiveStream;
import mil.jfcom.cie.media.srtp.data.SRTPSendStream;

public class SRTPEngine {
    private static final int AES_BLOCK_SIZE = 16;
    private static final int DEFAULT_AUTH_KEY_SIZE = 20;
    private static final int DEFAULT_ENC_KEY_SIZE = 16;
    private static final int DEFAULT_MASTER_KEY_SIZE = 16;
    private static final int DEFAULT_MASTER_SALT_SIZE = 14;
    private static final int DEFAULT_SALT_SIZE = 14;
    private static final int DEFAULT_TAG_SIZE = 10;
    private static final int SRTCP_AUTH_KEY_LABEL = 4;
    private static final int SRTCP_ENC_KEY_LABEL = 3;
    private static final int SRTCP_SALT_LABEL = 5;
    private static final int SRTP_AUTH_KEY_LABEL = 1;
    private static final int SRTP_ENC_KEY_LABEL = 0;
    private static final int SRTP_SALT_LABEL = 2;
    private String authAlgorithmName = "HmacSHA1";
    private String encryptionAlgorithmName = "aes integer counter mode";
    private Key ka;
    private Key kaSRTCP;
    private Key ke;
    private Key keSRTCP;
    private byte[] ks;
    private byte[] ksSRTCP;
    private SecretKeySpec masterKey;
    private byte[] masterSalt;
    private int na = 20;
    private int ne = 16;
    private int ns = 14;
    private int ntag = 10;
    private final Map receiveSRTCPMap = new HashMap();
    private final Map receiveSRTPMap = new HashMap();
    private final Map sendSRTCPMap = new HashMap();
    private final Map sendSRTPMap = new HashMap();
    private final BaseProcessor srtcpReceiveProcessor = new BaseProcessor(this.receiveSRTCPMap){

        public int process(byte[] inPacket, int offset, int length, byte[] processedPacket, int outOffset) throws GeneralSecurityException {
            return this.processStream(inPacket, offset, length, processedPacket, outOffset, 4);
        }

        protected BaseStream createProcessor() throws GeneralSecurityException {
            return new SRTCPReceiveStream(SRTPEngine.this.keSRTCP, SRTPEngine.this.kaSRTCP, SRTPEngine.this.ksSRTCP, SRTPEngine.this.ntag);
        }
    };
    private final BaseProcessor srtcpSendProcessor = new BaseProcessor(this.sendSRTCPMap){

        public int process(byte[] inPacket, int offset, int length, byte[] processedPacket, int outOffset) throws GeneralSecurityException {
            return this.processStream(inPacket, offset, length, processedPacket, outOffset, 4);
        }

        protected BaseStream createProcessor() throws GeneralSecurityException {
            return new SRTCPSendStream(SRTPEngine.this.keSRTCP, SRTPEngine.this.kaSRTCP, SRTPEngine.this.ksSRTCP, SRTPEngine.this.ntag);
        }
    };
    private final BaseProcessor srtpReceiveProcessor = new BaseProcessor(this.receiveSRTPMap){
        private byte[] srtpPacket;

        public int process(byte[] inPacket, int offset, int length, byte[] processedPacket, int outOffset) throws GeneralSecurityException {
            this.srtpPacket = inPacket;
            int len = this.processStream(inPacket, offset, length, processedPacket, outOffset, 8);
            this.srtpPacket = null;
            return len;
        }

        protected BaseStream createProcessor() throws GeneralSecurityException {
            return new SRTPReceiveStream(SRTPEngine.this.ke, SRTPEngine.this.ka, SRTPEngine.this.ks, SRTPEngine.this.ntag, this.srtpPacket);
        }
    };
    private final BaseProcessor srtpSendProcessor = new BaseProcessor(this.sendSRTPMap){

        public int process(byte[] inPacket, int offset, int length, byte[] processedPacket, int outOffset) throws GeneralSecurityException {
            return this.processStream(inPacket, offset, length, processedPacket, outOffset, 8);
        }

        protected BaseStream createProcessor() throws GeneralSecurityException {
            return new SRTPSendStream(SRTPEngine.this.ke, SRTPEngine.this.ka, SRTPEngine.this.ks, SRTPEngine.this.ntag);
        }
    };

    public SRTPEngine(byte[] masterKey, byte[] masterSalt) throws GeneralSecurityException {
        this.setMasterKey(masterKey, masterSalt);
    }

    public String getAuthAlgorithmName() {
        return this.authAlgorithmName;
    }

    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithmName;
    }

    public BaseProcessor getSRTCPReceiveProcessor() {
        return this.srtcpReceiveProcessor;
    }

    public BaseProcessor getSRTCPSendProcessor() {
        return this.srtcpSendProcessor;
    }

    public BaseProcessor getSRTPReceiveProcessor() {
        return this.srtpReceiveProcessor;
    }

    public BaseProcessor getSRTPSendProcessor() {
        return this.srtpSendProcessor;
    }

    public final void setMasterKey(byte[] masterKeyV, byte[] masterSaltV) throws GeneralSecurityException {
        if (masterKeyV == null || masterKeyV.length != 16) {
            throw new InvalidKeyException("Only 128-bit master key size is supported.");
        }
        if (masterSaltV == null || masterSaltV.length != 14) {
            throw new InvalidKeyException("Only 112-bit master salt size is supported.");
        }
        this.masterKey = new SecretKeySpec(masterKeyV, "AES");
        this.masterSalt = masterSaltV;
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, this.masterKey);
        this.ke = new SecretKeySpec(this.generateSessionKey((byte)0, this.ne, cipher), "AES");
        this.ka = new SecretKeySpec(this.generateSessionKey((byte)1, this.na, cipher), "AES");
        this.ks = this.generateSessionKey((byte)2, this.ns, cipher);
        this.keSRTCP = new SecretKeySpec(this.generateSessionKey((byte)3, this.ne, cipher), "AES");
        this.kaSRTCP = new SecretKeySpec(this.generateSessionKey((byte)4, this.na, cipher), "AES");
        this.ksSRTCP = this.generateSessionKey((byte)5, this.ns, cipher);
    }

    private byte[] generateSessionKey(byte label, int length, Cipher cipher) throws GeneralSecurityException {
        byte[] x = new byte[16];
        for (int i = 0; i < x.length; ++i) {
            x[i] = 0;
        }
        x[7] = label;
        SRTPUtil.xor(this.masterSalt, x, 0, this.masterSalt.length, x, 0);
        return SRTPUtil.generateKeyStream(cipher, x, length);
    }
}

