/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public final class SRTPUtil {
    private static final int MAX_ENCRYPT_PACKET_SIZE = 0x100000;

    public static void runCipher(Cipher cipher, byte[] iv, byte[] data, int offset, int len, byte[] result, int resultOffset) throws GeneralSecurityException {
        byte[] keyStream = SRTPUtil.generateKeyStream(cipher, iv, len);
        SRTPUtil.xor(keyStream, data, offset, len, result, resultOffset);
        int j = offset;
        int iout = resultOffset;
        int i = 0;
        while (i < len) {
            result[iout] = (byte)(data[j] ^ keyStream[i]);
            ++i;
            ++j;
            ++iout;
        }
    }

    private SRTPUtil() {
    }

    public static byte[] generateKeyStream(Cipher cipher, byte[] iv, int byteToGen) throws GeneralSecurityException {
        byte[] generated;
        block5: {
            if (byteToGen > 0x100000) {
                throw new IllegalArgumentException("SRTP max encryption size exceeded.");
            }
            if (iv.length < 16) {
                throw new IllegalArgumentException("AES IV must be 128 bits.");
            }
            generated = new byte[byteToGen];
            int offset = 0;
            int toGenerate = byteToGen;
            while (toGenerate > 15) {
                cipher.doFinal(iv, 0, 16, generated, offset);
                if ((toGenerate -= 16) != 0) {
                    offset += 16;
                    iv[15] = (byte)(iv[15] + 1);
                    if (iv[15] != 0) continue;
                    iv[14] = (byte)(iv[14] + 1);
                    continue;
                }
                break block5;
            }
            byte[] ks = cipher.doFinal(iv);
            int i = 0;
            while (i < toGenerate) {
                generated[offset] = ks[i];
                ++i;
                ++offset;
            }
        }
        return generated;
    }

    public static void xor(byte[] keyStream, byte[] data, int offset, int length, byte[] result, int resultOffset) {
        int i = 0;
        int j = resultOffset;
        int k = offset;
        while (i < length) {
            result[j] = (byte)(data[k] ^ keyStream[i]);
            ++i;
            ++k;
            ++j;
        }
    }

    public static void int2bytes(int intValue, byte[] bytes, int offset) {
        int value = intValue;
        int i = offset + 3;
        bytes[i--] = (byte)value;
        bytes[i--] = (byte)(value >>= 8);
        bytes[i--] = (byte)(value >>= 8);
        bytes[i] = (byte)(value >>= 8);
    }

    public static int bytes2int(byte[] bytes, int offset) {
        int i = offset;
        return (bytes[i] & 0xFF) << 24 | (bytes[++i] & 0xFF) << 16 | (bytes[++i] & 0xFF) << 8 | bytes[++i] & 0xFF;
    }
}

