/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.control;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyManagementException;
import mil.jfcom.cie.media.srtp.SRTPUtil;
import mil.jfcom.cie.media.srtp.control.SRTCPStream;

public class SRTCPSendStream
extends SRTCPStream {
    private int index = 0;

    public SRTCPSendStream(Key ke, Key ka, byte[] ks, int ntag) throws GeneralSecurityException {
        super(ke, ka, ks, ntag);
    }

    public int process(byte[] rtcpPacket, int inOffset, int length, byte[] outputSRTCP, int outOffset) throws GeneralSecurityException {
        if (this.packetsUsingMasterKey > Integer.MAX_VALUE) {
            throw new KeyManagementException("Master key's max SRTP packet number of 2^48 has been exceeded.");
        }
        int posSSRC = inOffset + 4;
        byte[] iv = new byte[]{0, 0, 0, 0, rtcpPacket[posSSRC++], rtcpPacket[posSSRC++], rtcpPacket[posSSRC++], rtcpPacket[posSSRC], 0, 0, (byte)(this.index >> 24 & 0x7F), (byte)(this.index >> 16 & 0xFF), (byte)(this.index >> 8 & 0xFF), (byte)(this.index & 0xFF), 0, 0};
        int end = length + outOffset;
        outputSRTCP[end++] = (byte)(iv[10] | 0x80);
        outputSRTCP[end++] = iv[11];
        outputSRTCP[end++] = iv[12];
        outputSRTCP[end++] = iv[13];
        SRTPUtil.xor(this.ks, iv, 0, this.ns, iv, 0);
        SRTPUtil.runCipher(this.cipher, iv, rtcpPacket, 8 + inOffset, length - 8, outputSRTCP, 8 + outOffset);
        System.arraycopy(rtcpPacket, inOffset, outputSRTCP, outOffset, 8);
        this.mac.update(outputSRTCP, outOffset, end - outOffset);
        this.mac.doFinal(outputSRTCP, end);
        ++this.index;
        ++this.packetsUsingMasterKey;
        return end + this.ntag;
    }

    private void replaceSSRC(byte[] rtcpPacket, int inOffset, int end, byte[] newSSRC) {
        int ptr = inOffset;
        block6: while (ptr < end) {
            int rc = rtcpPacket[ptr] & 0xF;
            int type = rtcpPacket[ptr + 1] & 0xFF;
            int len = rtcpPacket[ptr + 3] & 0xFF | (rtcpPacket[ptr + 2] & 0xFF) << 8;
            ptr += 4;
            int reportLen = 4;
            switch (type) {
                case 200: {
                    reportLen = 24;
                }
                case 201: {
                    System.arraycopy(newSSRC, 0, rtcpPacket, ptr, 4);
                    ptr += reportLen;
                    for (int i = 0; i < rc; ++i) {
                        System.arraycopy(newSSRC, 0, rtcpPacket, ptr, 4);
                        ptr += 24;
                    }
                    continue block6;
                }
                case 202: {
                    if (rc > 0) {
                        System.arraycopy(newSSRC, 0, rtcpPacket, ptr, 4);
                    }
                    ptr += len * 4;
                    break;
                }
                case 203: 
                case 204: {
                    System.arraycopy(newSSRC, 0, rtcpPacket, ptr, 4);
                    ptr += len * 4;
                    break;
                }
            }
        }
    }
}

