/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.packetizer;

public class KissFFT {
    private static final double PI = Math.PI;
    private KissFFTRcfg backward;
    private KissFFTRcfg forward;
    private KissFFTcpx[] freqData;
    private int nN;

    private static void kfFactor(int n, int[] facbuf) {
        int p = 4;
        double floorSqrt = Math.floor(Math.sqrt(n));
        int ifac = 0;
        while (true) {
            if (n % p != 0) {
                switch (p) {
                    case 4: {
                        p = 2;
                        break;
                    }
                    case 2: {
                        p = 3;
                        break;
                    }
                    default: {
                        p += 2;
                    }
                }
                if (!((double)p > floorSqrt)) continue;
                p = n;
                continue;
            }
            facbuf[ifac++] = p;
            facbuf[ifac++] = n /= p;
            if (n <= 1) break;
        }
    }

    public KissFFT(int size) {
        this.forward = new KissFFTRcfg(size, 0);
        this.backward = new KissFFTRcfg(size, 1);
        this.freqData = new KissFFTcpx[(size >> 1) + 1];
        this.nN = size;
        for (int i = 0; i < this.freqData.length; ++i) {
            this.freqData[i] = new KissFFTcpx();
        }
    }

    public void spxFFT(float[] in, float[] out, int offset) {
        int i;
        float scale = 1.0f / (float)this.nN;
        this.forward.kissFFTr(in, this.freqData);
        out[offset] = scale * this.freqData[0].r;
        int end = this.nN >> 1;
        for (i = 1; i < end; ++i) {
            int j = (i << 1) + offset;
            out[j - 1] = scale * this.freqData[i].r;
            out[j] = scale * this.freqData[i].i;
        }
        out[offset + (i << 1) - 1] = scale * this.freqData[i].r;
    }

    public void spxIFFT(float[] in, int offset, float[] out) {
        int i;
        this.freqData[0].r = in[offset];
        this.freqData[0].i = 0.0f;
        for (i = 1; i < this.nN >> 1; ++i) {
            int j = (i << 1) + offset;
            this.freqData[i].r = in[j - 1];
            this.freqData[i].i = in[j];
        }
        this.freqData[i].r = in[offset + (i << 1) - 1];
        this.freqData[i].i = 0.0f;
        this.backward.kissFFTri(this.freqData, out);
    }

    private static class KissFFTRcfg {
        private KissFFTcfg substate;
        private KissFFTcpx[] superTwiddles;
        private KissFFTcpx[] tmpbuf;

        KissFFTRcfg(int nfft, int inverseFFT) {
            if ((nfft & 1) != 0) {
                throw new IllegalArgumentException("Real FFT optimization must be even.");
            }
            this.substate = new KissFFTcfg(nfft >>= 1, inverseFFT);
            this.superTwiddles = new KissFFTcpx[nfft];
            this.tmpbuf = new KissFFTcpx[nfft];
            for (int i = 0; i < nfft; ++i) {
                this.tmpbuf[i] = new KissFFTcpx();
                double phase = -Math.PI * ((double)i / (double)nfft + 0.5);
                if (inverseFFT != 0) {
                    phase *= -1.0;
                }
                this.superTwiddles[i] = new KissFFTcpx();
                KissFFTcpx tw = this.superTwiddles[i];
                tw.r = (float)Math.cos(phase);
                tw.i = (float)Math.sin(phase);
            }
        }

        private void kissFFTr(float[] timedata, KissFFTcpx[] freqdata) {
            KissFFTcpx fpnk = new KissFFTcpx();
            KissFFTcpx f1k = new KissFFTcpx();
            KissFFTcpx f2k = new KissFFTcpx();
            KissFFTcpx tw = new KissFFTcpx();
            KissFFTcpx tdc = new KissFFTcpx();
            if (this.substate.inverse != 0) {
                throw new IllegalStateException("Kiss FFTR usage error: substate.inverse should be 0");
            }
            int ncfft = this.substate.nfft;
            this.substate.kissFFT(timedata, this.tmpbuf);
            tdc.r = this.tmpbuf[0].r;
            tdc.i = this.tmpbuf[0].i;
            freqdata[0].r = tdc.r + tdc.i;
            freqdata[ncfft].r = tdc.r - tdc.i;
            freqdata[0].i = 0.0f;
            freqdata[ncfft].i = 0.0f;
            for (int k = 1; k <= ncfft / 2; ++k) {
                KissFFTcpx fpk = this.tmpbuf[k];
                fpnk.r = this.tmpbuf[ncfft - k].r;
                fpnk.i = -this.tmpbuf[ncfft - k].i;
                f1k.r = fpk.r + fpnk.r;
                f1k.i = fpk.i + fpnk.i;
                f2k.r = fpk.r - fpnk.r;
                f2k.i = fpk.i - fpnk.i;
                tw.r = f2k.r * this.superTwiddles[k].r - f2k.i * this.superTwiddles[k].i;
                tw.i = f2k.r * this.superTwiddles[k].i + f2k.i * this.superTwiddles[k].r;
                freqdata[k].r = 0.5f * (f1k.r + tw.r);
                freqdata[k].i = 0.5f * (f1k.i + tw.i);
                freqdata[ncfft - k].r = 0.5f * (f1k.r - tw.r);
                freqdata[ncfft - k].i = 0.5f * (tw.i - f1k.i);
            }
        }

        private void kissFFTri(KissFFTcpx[] freqdata, float[] timedata) {
            if (this.substate.inverse == 0) {
                throw new IllegalStateException("Kiss FFTRI usage error: substate.inverse should not be 0");
            }
            int ncfft = this.substate.nfft;
            this.tmpbuf[0].r = freqdata[0].r + freqdata[ncfft].r;
            this.tmpbuf[0].i = freqdata[0].r - freqdata[ncfft].r;
            KissFFTcpx fnkc = new KissFFTcpx();
            KissFFTcpx fek = new KissFFTcpx();
            KissFFTcpx fok = new KissFFTcpx();
            KissFFTcpx tmp = new KissFFTcpx();
            for (int k = 1; k <= ncfft / 2; ++k) {
                KissFFTcpx fk = freqdata[k];
                fnkc.r = freqdata[ncfft - k].r;
                fnkc.i = -freqdata[ncfft - k].i;
                fek.r = fk.r + fnkc.r;
                fek.i = fk.i + fnkc.i;
                tmp.r = fk.r - fnkc.r;
                tmp.i = fk.i - fnkc.i;
                fok.r = tmp.r * this.superTwiddles[k].r - tmp.i * this.superTwiddles[k].i;
                fok.i = tmp.r * this.superTwiddles[k].i + tmp.i * this.superTwiddles[k].r;
                this.tmpbuf[k].r = fek.r + fok.r;
                this.tmpbuf[k].i = fek.i + fok.i;
                this.tmpbuf[ncfft - k].r = fek.r - fok.r;
                this.tmpbuf[ncfft - k].i = fek.i - fok.i;
                this.tmpbuf[ncfft - k].i *= -1.0f;
            }
            this.substate.kissFFT(this.tmpbuf, timedata);
        }
    }

    private static class KissFFTcpx {
        float r;
        float i;

        private KissFFTcpx() {
        }
    }

    private static class KissFFTcfg {
        private final int[] factors = new int[64];
        private int inverse;
        private int nfft;
        private int nscratchbuf;
        private KissFFTcpx[] scratchbuf;
        private KissFFTcpx[] twiddles;
        private final KissFFTcpx[] scratch = new KissFFTcpx[13];

        KissFFTcfg(int nFFT, int inverseFFT) {
            int i;
            this.twiddles = new KissFFTcpx[nFFT];
            this.nfft = nFFT;
            this.inverse = inverseFFT;
            for (i = 0; i < nFFT; ++i) {
                double phase = Math.PI * -2 / (double)nFFT * (double)i;
                if (this.inverse != 0) {
                    phase *= -1.0;
                }
                this.twiddles[i] = new KissFFTcpx();
                KissFFTcpx tw = this.twiddles[i];
                tw.r = (float)Math.cos(phase);
                tw.i = (float)Math.sin(phase);
            }
            for (i = 0; i < this.scratch.length; ++i) {
                this.scratch[i] = new KissFFTcpx();
            }
            KissFFT.kfFactor(nFFT, this.factors);
        }

        private void kfBflyGeneric(KissFFTcpx[] fout, int ifout, int fstride, int m, int p) {
            KissFFTcpx t = new KissFFTcpx();
            int nNorig = this.nfft;
            if (this.nscratchbuf < p) {
                this.scratchbuf = new KissFFTcpx[p];
                for (int i = 0; i < p; ++i) {
                    this.scratchbuf[i] = new KissFFTcpx();
                }
                this.nscratchbuf = p;
            }
            for (int u = 0; u < m; ++u) {
                int q1;
                int k = u;
                for (q1 = 0; q1 < p; ++q1) {
                    this.scratchbuf[q1].i = fout[ifout + k].i;
                    this.scratchbuf[q1].r = fout[ifout + k].r;
                    k += m;
                }
                k = u;
                for (q1 = 0; q1 < p; ++q1) {
                    int twidx = 0;
                    fout[ifout + k].r = this.scratchbuf[0].r;
                    fout[ifout + k].i = this.scratchbuf[0].i;
                    for (int q = 1; q < p; ++q) {
                        if ((twidx += fstride * k) >= nNorig) {
                            twidx -= nNorig;
                        }
                        t.r = this.scratchbuf[q].r * this.twiddles[twidx].r - this.scratchbuf[q].i * this.twiddles[twidx].i;
                        t.i = this.scratchbuf[q].r * this.twiddles[twidx].i + this.scratchbuf[q].i * this.twiddles[twidx].r;
                        fout[ifout + k].r += t.r;
                        fout[ifout + k].i += t.i;
                    }
                    k += m;
                }
            }
        }

        private void kfBfly2(KissFFTcpx[] fout, int ifout, int fstride, int m) {
            int tw1 = 0;
            KissFFTcpx t = new KissFFTcpx();
            int fout2 = ifout + m;
            do {
                t.r = fout[fout2].r * this.twiddles[tw1].r - fout[fout2].i * this.twiddles[tw1].i;
                t.i = fout[fout2].r * this.twiddles[tw1].i + fout[fout2].i * this.twiddles[tw1].r;
                tw1 += fstride;
                fout[fout2].r = fout[ifout].r - t.r;
                fout[fout2].i = fout[ifout].i - t.i;
                fout[ifout].r += t.r;
                fout[ifout].i += t.i;
                ++fout2;
                ++ifout;
            } while (--m != 0);
        }

        private void kfBfly3(KissFFTcpx[] fout, int ifout, int fstride, int m) {
            int k = m;
            int m2 = 2 * m;
            int tw1 = 0;
            int tw2 = 0;
            KissFFTcpx epi3 = this.twiddles[fstride * m];
            do {
                int mm = ifout + m;
                int mm2 = ifout + m2;
                this.scratch[1].r = fout[mm].r * this.twiddles[tw1].r - fout[mm].i * this.twiddles[tw1].i;
                this.scratch[1].i = fout[mm].r * this.twiddles[tw1].i + fout[mm].i * this.twiddles[tw1].r;
                this.scratch[2].r = fout[mm2].r * this.twiddles[tw2].r - fout[mm2].i * this.twiddles[tw2].i;
                this.scratch[2].i = fout[mm2].r * this.twiddles[tw2].i + fout[mm2].i * this.twiddles[tw2].r;
                this.scratch[3].r = this.scratch[1].r + this.scratch[2].r;
                this.scratch[3].i = this.scratch[1].i + this.scratch[2].i;
                this.scratch[0].r = this.scratch[1].r - this.scratch[2].r;
                this.scratch[0].i = this.scratch[1].i - this.scratch[2].i;
                tw1 += fstride;
                tw2 += fstride * 2;
                fout[mm].r = fout[ifout].r - 0.5f * this.scratch[3].r;
                fout[mm].i = fout[ifout].i - 0.5f * this.scratch[3].i;
                this.scratch[0].r *= epi3.i;
                this.scratch[0].i *= epi3.i;
                fout[ifout].r += this.scratch[3].r;
                fout[ifout].i += this.scratch[3].i;
                fout[mm2].r = fout[mm].r + this.scratch[0].i;
                fout[mm2].i = fout[mm].i - this.scratch[0].r;
                fout[mm].r -= this.scratch[0].i;
                fout[mm].i += this.scratch[0].r;
                ++ifout;
            } while (--k != 0);
        }

        private void kfBfly4(KissFFTcpx[] fout, int ifout, int fstride, int m) {
            int tw1 = 0;
            int tw2 = 0;
            int tw3 = 0;
            int k = m;
            int m2 = 2 * m;
            int m3 = 3 * m;
            if (this.inverse != 0) {
                do {
                    int mm = ifout + m;
                    int mm2 = ifout + m2;
                    int mm3 = ifout + m3;
                    this.scratch[0].r = fout[mm].r * this.twiddles[tw1].r - fout[mm].i * this.twiddles[tw1].i;
                    this.scratch[0].i = fout[mm].r * this.twiddles[tw1].i + fout[mm].i * this.twiddles[tw1].r;
                    this.scratch[1].r = fout[mm2].r * this.twiddles[tw2].r - fout[mm2].i * this.twiddles[tw2].i;
                    this.scratch[1].i = fout[mm2].r * this.twiddles[tw2].i + fout[mm2].i * this.twiddles[tw2].r;
                    this.scratch[2].r = fout[mm3].r * this.twiddles[tw3].r - fout[mm3].i * this.twiddles[tw3].i;
                    this.scratch[2].i = fout[mm3].r * this.twiddles[tw3].i + fout[mm3].i * this.twiddles[tw3].r;
                    this.scratch[5].r = fout[ifout].r - this.scratch[1].r;
                    this.scratch[5].i = fout[ifout].i - this.scratch[1].i;
                    fout[ifout].r += this.scratch[1].r;
                    fout[ifout].i += this.scratch[1].i;
                    this.scratch[3].r = this.scratch[0].r + this.scratch[2].r;
                    this.scratch[3].i = this.scratch[0].i + this.scratch[2].i;
                    this.scratch[4].r = this.scratch[0].r - this.scratch[2].r;
                    this.scratch[4].i = this.scratch[0].i - this.scratch[2].i;
                    fout[mm2].r = fout[ifout].r - this.scratch[3].r;
                    fout[mm2].i = fout[ifout].i - this.scratch[3].i;
                    tw1 += fstride;
                    tw2 += fstride * 2;
                    tw3 += fstride * 3;
                    fout[ifout].r += this.scratch[3].r;
                    fout[ifout].i += this.scratch[3].i;
                    fout[mm].r = this.scratch[5].r - this.scratch[4].i;
                    fout[mm].i = this.scratch[5].i + this.scratch[4].r;
                    fout[mm3].r = this.scratch[5].r + this.scratch[4].i;
                    fout[mm3].i = this.scratch[5].i - this.scratch[4].r;
                    ++ifout;
                } while (--k != 0);
            } else {
                do {
                    int mm = ifout + m;
                    int mm2 = ifout + m2;
                    int mm3 = ifout + m3;
                    this.scratch[0].r = fout[mm].r * this.twiddles[tw1].r - fout[mm].i * this.twiddles[tw1].i;
                    this.scratch[0].i = fout[mm].r * this.twiddles[tw1].i + fout[mm].i * this.twiddles[tw1].r;
                    this.scratch[1].r = fout[mm2].r * this.twiddles[tw2].r - fout[mm2].i * this.twiddles[tw2].i;
                    this.scratch[1].i = fout[mm2].r * this.twiddles[tw2].i + fout[mm2].i * this.twiddles[tw2].r;
                    this.scratch[2].r = fout[mm3].r * this.twiddles[tw3].r - fout[mm3].i * this.twiddles[tw3].i;
                    this.scratch[2].i = fout[mm3].r * this.twiddles[tw3].i + fout[mm3].i * this.twiddles[tw3].r;
                    this.scratch[5].r = fout[ifout].r - this.scratch[1].r;
                    this.scratch[5].i = fout[ifout].i - this.scratch[1].i;
                    fout[ifout].r += this.scratch[1].r;
                    fout[ifout].i += this.scratch[1].i;
                    this.scratch[3].r = this.scratch[0].r + this.scratch[2].r;
                    this.scratch[3].i = this.scratch[0].i + this.scratch[2].i;
                    this.scratch[4].r = this.scratch[0].r - this.scratch[2].r;
                    this.scratch[4].i = this.scratch[0].i - this.scratch[2].i;
                    fout[mm2].r = fout[ifout].r - this.scratch[3].r;
                    fout[mm2].i = fout[ifout].i - this.scratch[3].i;
                    tw1 += fstride;
                    tw2 += fstride * 2;
                    tw3 += fstride * 3;
                    fout[ifout].r += this.scratch[3].r;
                    fout[ifout].i += this.scratch[3].i;
                    fout[mm].r = this.scratch[5].r + this.scratch[4].i;
                    fout[mm].i = this.scratch[5].i - this.scratch[4].r;
                    fout[mm3].r = this.scratch[5].r - this.scratch[4].i;
                    fout[mm3].i = this.scratch[5].i + this.scratch[4].r;
                    ++ifout;
                } while (--k != 0);
            }
        }

        private void kfBfly5(KissFFTcpx[] fout, int ifout, int fstride, int m) {
            KissFFTcpx ya = new KissFFTcpx();
            KissFFTcpx yb = new KissFFTcpx();
            int i = fstride * m;
            ya.r = this.twiddles[i].r;
            ya.i = this.twiddles[i].i;
            i = fstride * 2 * m;
            yb.r = this.twiddles[i].r;
            yb.i = this.twiddles[i].i;
            int fout0 = ifout;
            int fout1 = fout0 + m;
            int fout2 = fout0 + 2 * m;
            int fout3 = fout0 + 3 * m;
            int fout4 = fout0 + 4 * m;
            for (int u = 0; u < m; ++u) {
                this.scratch[0].i = fout[fout0].i;
                this.scratch[0].r = fout[fout0].r;
                int ii = i = u * fstride;
                this.scratch[1].r = fout[fout1].r * this.twiddles[i].r - fout[fout1].i * this.twiddles[i].i;
                this.scratch[1].i = fout[fout1].r * this.twiddles[i].i + fout[fout1].i * this.twiddles[i].r;
                i = 2 * ii;
                this.scratch[2].r = fout[fout2].r * this.twiddles[i].r - fout[fout2].i * this.twiddles[i].i;
                this.scratch[2].i = fout[fout2].r * this.twiddles[i].i + fout[fout2].i * this.twiddles[i].r;
                i = 3 * ii;
                this.scratch[3].r = fout[fout3].r * this.twiddles[i].r - fout[fout3].i * this.twiddles[i].i;
                this.scratch[3].i = fout[fout3].r * this.twiddles[i].i + fout[fout3].i * this.twiddles[i].r;
                i = 4 * ii;
                this.scratch[4].r = fout[fout4].r * this.twiddles[i].r - fout[fout4].i * this.twiddles[i].i;
                this.scratch[4].i = fout[fout4].r * this.twiddles[i].i + fout[fout4].i * this.twiddles[i].r;
                this.scratch[7].r = this.scratch[1].r + this.scratch[4].r;
                this.scratch[7].i = this.scratch[1].i + this.scratch[4].i;
                this.scratch[10].r = this.scratch[1].r - this.scratch[4].r;
                this.scratch[10].i = this.scratch[1].i - this.scratch[4].i;
                this.scratch[8].r = this.scratch[2].r + this.scratch[3].r;
                this.scratch[8].i = this.scratch[2].i + this.scratch[3].i;
                this.scratch[9].r = this.scratch[2].r - this.scratch[3].r;
                this.scratch[9].i = this.scratch[2].i - this.scratch[3].i;
                fout[fout0].r += this.scratch[7].r + this.scratch[8].r;
                fout[fout0].i += this.scratch[7].i + this.scratch[8].i;
                this.scratch[5].r = this.scratch[0].r + this.scratch[7].r * ya.r + this.scratch[8].r * yb.r;
                this.scratch[5].i = this.scratch[0].i + this.scratch[7].i * ya.r + this.scratch[8].i * yb.r;
                this.scratch[6].r = this.scratch[10].i * ya.i + this.scratch[9].i * yb.i;
                this.scratch[6].i = -this.scratch[10].r * ya.i - this.scratch[9].r * yb.i;
                fout[fout1].r = this.scratch[5].r - this.scratch[6].r;
                fout[fout1].i = this.scratch[5].i - this.scratch[6].i;
                fout[fout4].r = this.scratch[5].r + this.scratch[6].r;
                fout[fout4].i = this.scratch[5].i + this.scratch[6].i;
                this.scratch[11].r = this.scratch[0].r + this.scratch[7].r * yb.r + this.scratch[8].r * ya.r;
                this.scratch[11].i = this.scratch[0].i + this.scratch[7].i * yb.r + this.scratch[8].i * ya.r;
                this.scratch[12].r = -this.scratch[10].i * yb.i + this.scratch[9].i * ya.i;
                this.scratch[12].i = this.scratch[10].r * yb.i - this.scratch[9].r * ya.i;
                fout[fout2].r = this.scratch[11].r + this.scratch[12].r;
                fout[fout2].i = this.scratch[11].i + this.scratch[12].i;
                fout[fout3].r = this.scratch[11].r - this.scratch[12].r;
                fout[fout3].i = this.scratch[11].i - this.scratch[12].i;
                ++fout0;
                ++fout1;
                ++fout2;
                ++fout3;
                ++fout4;
            }
        }

        private void kfWork(KissFFTcpx[] fout, int iifout, KissFFTcpx[] f, int iiF, int fstride, int inStride, int iiFactors) {
            int ifout;
            int iFactors = iiFactors;
            int iF = iiF;
            int foutBeg = ifout = iifout;
            int p = this.factors[iFactors++];
            int m = this.factors[iFactors++];
            int foutEnd = ifout + p * m;
            if (m == 1) {
                do {
                    fout[ifout].i = f[iF].i;
                    fout[ifout].r = f[iF].r;
                    iF += fstride * inStride;
                } while (++ifout != foutEnd);
            } else {
                do {
                    this.kfWork(fout, ifout, f, iF, fstride * p, inStride, iFactors);
                    iF += fstride * inStride;
                } while ((ifout += m) != foutEnd);
            }
            ifout = foutBeg;
            switch (p) {
                case 2: {
                    this.kfBfly2(fout, ifout, fstride, m);
                    break;
                }
                case 3: {
                    this.kfBfly3(fout, ifout, fstride, m);
                    break;
                }
                case 4: {
                    this.kfBfly4(fout, ifout, fstride, m);
                    break;
                }
                case 5: {
                    this.kfBfly5(fout, ifout, fstride, m);
                    break;
                }
                default: {
                    this.kfBflyGeneric(fout, ifout, fstride, m, p);
                }
            }
        }

        void kissFFT(float[] timedata, KissFFTcpx[] tmpbuf) {
            int len = timedata.length / 2;
            KissFFTcpx[] fin = new KissFFTcpx[len];
            int j = 0;
            for (int i = 0; i < len; ++i) {
                fin[i] = new KissFFTcpx();
                KissFFTcpx tmp = fin[i];
                tmp.r = timedata[j++];
                tmp.i = timedata[j++];
            }
            this.kissFFTstride(fin, tmpbuf, 1);
        }

        private void kissFFT(KissFFTcpx[] tmpbuf, float[] timedata) {
            int i;
            int len = timedata.length / 2;
            KissFFTcpx[] fout = new KissFFTcpx[len];
            for (i = 0; i < len; ++i) {
                fout[i] = new KissFFTcpx();
            }
            this.kissFFTstride(tmpbuf, fout, 1);
            int j = 0;
            for (i = 0; i < len; ++i) {
                timedata[j++] = fout[i].r;
                timedata[j++] = fout[i].i;
            }
        }

        private void kissFFTstride(KissFFTcpx[] fin, KissFFTcpx[] fout, int inStride) {
            this.kfWork(fout, 0, fin, 0, 1, inStride, 0);
        }
    }
}

