/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp.packetizer;

import com.sun.media.codec.audio.AudioCodec;
import java.io.StreamCorruptedException;
import java.nio.BufferUnderflowException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import mil.jfcom.cie.media.srtp.Logging;
import mil.jfcom.cie.media.srtp.packetizer.SpeexFormat;
import mil.jfcom.cie.media.srtp.packetizer.SpeexPacketizer;
import org.xiph.speex.SpeexDecoder;

public class SpeexDepacketizer
extends AudioCodec {
    public static final AudioFormat LINEAR_FORMAT = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private SpeexDecoder decoder;

    public SpeexDepacketizer() {
        this.inputFormats = new Format[]{SpeexFormat.SPEEX_RTP_FORMAT};
        this.decoder = new SpeexDecoder();
        this.decoder.init(0, 8000, 1, false);
    }

    public String getName() {
        return "Speex Depacketizer";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        return new Format[]{LINEAR_FORMAT};
    }

    public int process(Buffer input, Buffer output) {
        byte[] inData = (byte[])input.getData();
        int inOffset = input.getOffset();
        int inLength = input.getLength();
        Thread.currentThread().setPriority(10);
        try {
            try {
                this.decoder.processData(inData, inOffset, inLength);
                this.decoder.processData(false);
            }
            catch (BufferUnderflowException e) {
                Logging.LOG.error((Object)"Audio decode buffer underflow");
            }
            int numberBytes = this.decoder.getProcessedDataByteSize();
            int numberShorts = numberBytes / 2;
            short[] processedShorts = new short[numberShorts];
            this.decoder.getProcessedData(processedShorts, 0);
            byte[] processedBytes = new byte[numberBytes];
            for (int i = 0; i < numberShorts; ++i) {
                int dx = i << 1;
                processedBytes[dx] = (byte)(processedShorts[i] & 0xFF);
                processedBytes[dx + 1] = (byte)(processedShorts[i] >> 8 & 0xFF);
            }
            output.setData((Object)processedBytes);
            output.setOffset(0);
            output.setLength(numberBytes);
            SpeexPacketizer.addLastPlayBuffer(processedShorts);
            return 0;
        }
        catch (StreamCorruptedException e) {
            Logging.LOG.error((Object)"Audio decode buffer underflow", (Throwable)e);
            return 1;
        }
    }
}

