/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.openpgp;

import nu.fw.jeti.events.JETIListener;
import nu.fw.jeti.events.PresenceListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.openpgp.Encrypter;
import nu.fw.jeti.plugins.openpgp.XEncryptedHandler;
import nu.fw.jeti.plugins.openpgp.XSignedHandler;

public class Plugin
implements Plugins {
    public static final String VERSION = "0.1";
    public static final String DESCRIPTION = "openpgp.Encryption";
    public static final String MIN_JETI_VERSION = "0.6";
    public static final String NAME = "openpgp";
    public static final String ABOUT = "by E.S. de Boer";
    private static Plugin plugin;
    private Encrypter encrypter;

    public Plugin(Backend backend) {
        PluginsInfo.loadLibrary((String)"cryptix-pki-api");
        PluginsInfo.loadLibrary((String)"cryptix-jce-api");
        PluginsInfo.loadLibrary((String)"cryptix-openpgp-provider");
        PluginsInfo.loadLibrary((String)"cryptix-message-api");
        PluginsInfo.loadLibrary((String)"cryptix-jce-provider");
        this.encrypter = new Encrypter();
        backend.addListener(PresenceListener.class, (JETIListener)this.encrypter);
        backend.addExtensionHandler("jabber:x:signed", (ExtensionHandler)new XSignedHandler());
        backend.addExtensionHandler("jabber:x:encrypted", (ExtensionHandler)new XEncryptedHandler());
    }

    public static void init(Backend backend) {
        plugin = new Plugin(backend);
    }

    public void unload() {
    }

    public static Object getInstance() {
        return Encrypter.getInstance();
    }

    public static void unload(Backend backend) {
        backend.removeListener(PresenceListener.class, (JETIListener)Plugin.plugin.encrypter);
        backend.removeExtensionHandler("jabber:x:signed");
        backend.removeExtensionHandler("jabber:x:encrypted");
        plugin.unload();
        plugin = null;
    }
}

