/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.md;

import cryptix.jce.provider.md.PaddingMD;

public abstract class SHA512Base
extends PaddingMD {
    private static final int BLOCK_SIZE = 128;
    private static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private final long[] context;
    private final long[] buffer;

    public SHA512Base(int hashSize) {
        super(128, hashSize, 1);
        this.context = new long[8];
        this.buffer = new long[80];
        this.coreReset();
    }

    protected SHA512Base(SHA512Base src) {
        super(src);
        this.context = (long[])src.context.clone();
        this.buffer = (long[])src.buffer.clone();
    }

    private final long Ch(long x, long y, long z) {
        return x & y ^ (x ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private final long Maj(long x, long y, long z) {
        return x & y ^ x & z ^ y & z;
    }

    private final long R(int off, long x) {
        return x >>> off;
    }

    private final long S(int off, long x) {
        return x >>> off | x << 64 - off;
    }

    private final long Sig0(long x) {
        return this.S(28, x) ^ this.S(34, x) ^ this.S(39, x);
    }

    private final long Sig1(long x) {
        return this.S(14, x) ^ this.S(18, x) ^ this.S(41, x);
    }

    protected void coreDigest(byte[] buf, int off) {
        this.generateDigest(this.context, buf, off);
    }

    protected void coreReset() {
        this.loadInitialValues(this.context);
    }

    protected void coreUpdate(byte[] block, int offset) {
        long[] W = this.buffer;
        int i = 0;
        while (i < 16) {
            W[i] = (long)block[offset++] << 56 | ((long)block[offset++] & 0xFFL) << 48 | ((long)block[offset++] & 0xFFL) << 40 | ((long)block[offset++] & 0xFFL) << 32 | ((long)block[offset++] & 0xFFL) << 24 | ((long)block[offset++] & 0xFFL) << 16 | ((long)block[offset++] & 0xFFL) << 8 | (long)block[offset++] & 0xFFL;
            ++i;
        }
        int i2 = 16;
        while (i2 < 80) {
            W[i2] = this.sig1(W[i2 - 2]) + W[i2 - 7] + this.sig0(W[i2 - 15]) + W[i2 - 16];
            ++i2;
        }
        long a = this.context[0];
        long b = this.context[1];
        long c = this.context[2];
        long d = this.context[3];
        long e = this.context[4];
        long f = this.context[5];
        long g = this.context[6];
        long h = this.context[7];
        int i3 = 0;
        while (i3 < 80) {
            long T1 = h + this.Sig1(e) + this.Ch(e, f, g) + K[i3] + W[i3];
            long T2 = this.Sig0(a) + this.Maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
            ++i3;
        }
        this.context[0] = this.context[0] + a;
        this.context[1] = this.context[1] + b;
        this.context[2] = this.context[2] + c;
        this.context[3] = this.context[3] + d;
        this.context[4] = this.context[4] + e;
        this.context[5] = this.context[5] + f;
        this.context[6] = this.context[6] + g;
        this.context[7] = this.context[7] + h;
    }

    protected abstract void generateDigest(long[] var1, byte[] var2, int var3);

    protected abstract void loadInitialValues(long[] var1);

    private final long sig0(long x) {
        return this.S(1, x) ^ this.S(8, x) ^ this.R(7, x);
    }

    private final long sig1(long x) {
        return this.S(19, x) ^ this.S(61, x) ^ this.R(6, x);
    }
}

