/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message;

import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.MessageFactorySpi;
import cryptix.message.Support;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Collection;

public class MessageFactory {
    private final MessageFactorySpi spi;
    private final Provider provider;
    private final String format;

    protected MessageFactory(MessageFactorySpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final Message generateMessage(InputStream in) throws MessageException, IOException {
        return this.spi.engineGenerateMessage(in);
    }

    public final Collection generateMessages(InputStream in) throws MessageException, IOException {
        return this.spi.engineGenerateMessages(in);
    }

    public final String getFormat() {
        return this.format;
    }

    public static MessageFactory getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("MessageFactory", format);
        return new MessageFactory((MessageFactorySpi)o[0], (Provider)o[1], format);
    }

    public static MessageFactory getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("MessageFactory", format, provider);
        return new MessageFactory((MessageFactorySpi)o[0], (Provider)o[1], format);
    }

    public static MessageFactory getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("MessageFactory", format, provider);
        return new MessageFactory((MessageFactorySpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

