/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message.stream;

import cryptix.message.stream.MessageOutputStreamSpi;
import cryptix.message.stream.MessageStreamException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;

public abstract class MessageOutputStream
extends OutputStream {
    protected final MessageOutputStreamSpi spi;
    private final Provider provider;
    private final String format;

    protected MessageOutputStream(MessageOutputStreamSpi spi, Provider provider, String format) {
        this.spi = spi;
        this.provider = provider;
        this.format = format;
    }

    public final void close() throws IOException, MessageStreamException {
        this.spi.engineClose();
    }

    public final void flush() throws IOException, MessageStreamException {
        this.spi.engineFlush();
    }

    public final String getFormat() {
        return this.format;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final MessageOutputStreamSpi getSpi() {
        return this.spi;
    }

    public final void init(OutputStream out, SecureRandom sr) throws IllegalStateException, IOException, MessageStreamException {
        this.spi.engineInit(out, sr);
    }

    public final void setAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageStreamException {
        this.spi.engineSetAttribute(name, attr);
    }

    public final void write(int b) throws IOException, MessageStreamException {
        this.spi.engineWrite(b);
    }

    public final void write(byte[] b) throws IOException, MessageStreamException {
        this.spi.engineWrite(b, 0, b.length);
    }

    public final void write(byte[] b, int off, int len) throws IOException, MessageStreamException {
        this.spi.engineWrite(b, off, len);
    }
}

