/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message.stream;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

final class Support {
    Support() {
    }

    static Object[] getClassName(String type, String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        if (providers == null || providers.length == 0) {
            throw new NoSuchAlgorithmException("No providers installed");
        }
        int i = 0;
        while (i < providers.length) {
            try {
                Object[] res = Support.getClassName(type, algorithm, providers[i]);
                return res;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
    }

    static Object[] getClassName(String type, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException("Provider not found. [" + provider + "]");
        }
        Object[] res = Support.getClassName(type, algorithm, p);
        return res;
    }

    static Object[] getClassName(String type, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        String class_name = ((Properties)provider).getProperty("Alg.Alias." + type + "." + algorithm);
        class_name = class_name == null ? ((Properties)provider).getProperty(String.valueOf(type) + "." + algorithm) : ((Properties)provider).getProperty(String.valueOf(type) + "." + class_name);
        if (class_name == null) {
            throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
        }
        Object[] res = new Object[]{class_name, provider};
        return res;
    }

    static Object[] getImplementation(String type, String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        if (providers == null || providers.length == 0) {
            throw new NoSuchAlgorithmException("No providers installed");
        }
        int i = 0;
        while (i < providers.length) {
            try {
                Object[] res = Support.getImplementation(type, algorithm, providers[i]);
                return res;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++i;
            }
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
    }

    static Object[] getImplementation(String type, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException("Provider not found. [" + provider + "]");
        }
        Object[] res = Support.getImplementation(type, algorithm, p);
        return res;
    }

    static Object[] getImplementation(String type, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            String class_name = ((Properties)provider).getProperty("Alg.Alias." + type + "." + algorithm);
            class_name = class_name == null ? ((Properties)provider).getProperty(String.valueOf(type) + "." + algorithm) : ((Properties)provider).getProperty(String.valueOf(type) + "." + class_name);
            if (class_name == null) {
                throw new NoSuchAlgorithmException("Algorithm not found. [" + type + "." + algorithm + "]");
            }
            Object[] res = new Object[]{Class.forName(class_name).newInstance(), provider};
            return res;
        }
        catch (LinkageError linkageError) {
            throw new NoSuchAlgorithmException("Error initializing class. [" + type + "." + algorithm + "]");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("Registered class not found. [" + type + "." + algorithm + "]");
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("Error initializing class. [" + type + "." + algorithm + "]");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("Error initializing class. [" + type + "." + algorithm + "]");
        }
    }
}

