/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp;

import cryptix.message.KeyBundleMessage;
import cryptix.message.LiteralMessage;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.SignedMessage;
import cryptix.openpgp.PGPDetachedSignatureMessage;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPSignedMessage;
import cryptix.openpgp.util.PGPArmoury;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyBundleException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class PGPArmouredMessage
extends Message {
    private Message msg;
    private PGPKeyBundle bundle;

    public PGPArmouredMessage(Message msg) {
        super("OpenPGP");
        this.msg = msg;
        if (msg instanceof KeyBundleMessage) {
            this.bundle = (PGPKeyBundle)((KeyBundleMessage)msg).getKeyBundle();
        }
    }

    public PGPArmouredMessage(KeyBundle bundle) {
        super("OpenPGP");
        this.bundle = (PGPKeyBundle)bundle;
    }

    public Object getAttribute(String name) throws IllegalArgumentException, MessageException {
        throw new IllegalArgumentException("Attributes not supported.");
    }

    public Object getContents() {
        if (this.msg != null) {
            return this.msg;
        }
        return this.bundle;
    }

    public byte[] getEncoded() throws MessageException {
        try {
            return this.getEncodedString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError("UTF-8 encoding not supported - " + uee);
        }
    }

    public String getEncodedString() throws MessageException {
        try {
            PGPArmoury armoury;
            if (this.bundle != null) {
                armoury = this.bundle.containsPrivateKey() ? new PGPArmoury(this.bundle.getEncoded(), "PGP PRIVATE KEY BLOCK") : new PGPArmoury(this.bundle.getEncoded(), "PGP PUBLIC KEY BLOCK");
            } else if (this.msg instanceof PGPSignedMessage) {
                LiteralMessage contents = (LiteralMessage)((SignedMessage)this.msg).getContents();
                if (contents.getDataType() == 2) {
                    PGPDetachedSignatureMessage dsm = ((PGPSignedMessage)this.msg).getDetachedSignature();
                    Properties p = new Properties();
                    if (!((PGPSignedMessage)this.msg).isLegacy()) {
                        p.setProperty("Hash", (String)dsm.getAttribute("Hash"));
                    }
                    armoury = new PGPArmoury(p, contents.getBinaryData(), dsm.getEncoded());
                } else {
                    armoury = new PGPArmoury(this.msg.getEncoded());
                }
            } else {
                armoury = new PGPArmoury(this.msg.getEncoded());
            }
            return armoury.toString();
        }
        catch (KeyBundleException kbe) {
            throw new MessageException(String.valueOf(String.valueOf((Object)kbe)));
        }
    }
}

