/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp;

import cryptix.openpgp.PGPAbstractSignatureParameterBuilder;
import cryptix.openpgp.PGPPrincipal;
import cryptix.openpgp.signature.PGPBooleanSP;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPKeyFlagsSP;
import cryptix.openpgp.signature.PGPNotationDataSP;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.signature.PGPStringSP;
import cryptix.openpgp.signature.PGPTrustSP;
import cryptix.pki.KeyID;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class PGPCertificateParameterBuilder
extends PGPAbstractSignatureParameterBuilder {
    public PGPCertificateParameterBuilder(KeyID issuerkeyid) {
        super(issuerkeyid, (byte)16);
    }

    public PGPCertificateParameterBuilder(Key issuerkey) throws InvalidKeyException {
        super(issuerkey, (byte)16);
    }

    public void setExpirationDate(Date expiration) {
        if (expiration == null) {
            this.removePacket((byte)3);
        } else {
            PGPDateSP pkt = new PGPDateSP();
            pkt.setValue(expiration);
            pkt.setPacketID((byte)3);
            this.setPacket(pkt);
        }
    }

    public void setExportable(boolean exportable) {
        if (exportable) {
            this.removePacket((byte)4);
        } else {
            PGPBooleanSP pkt = new PGPBooleanSP();
            pkt.setValue(false);
            pkt.setPacketID((byte)4);
            this.setPacket(pkt);
        }
    }

    public void setIssuerUserID(PGPPrincipal issueruserid) {
        if (issueruserid == null) {
            this.removePacket((byte)28);
        } else {
            PGPStringSP pkt = new PGPStringSP();
            pkt.setValue(issueruserid.getName());
            pkt.setPacketID((byte)28);
            this.setPacket(pkt);
        }
    }

    public void setKeyFlags(boolean certification, boolean signdata, boolean encryptcommunication, boolean encryptstorage) {
        if (certification && signdata && encryptcommunication && encryptstorage) {
            this.removePacket((byte)27);
        } else {
            PGPKeyFlagsSP pkt = new PGPKeyFlagsSP();
            pkt.setCertify(certification);
            pkt.setSign(signdata);
            pkt.setEncryptCommunication(encryptcommunication);
            pkt.setEncryptStorage(encryptstorage);
            pkt.setPacketID((byte)27);
            this.setPacket(pkt);
        }
    }

    public void setNotationData(Properties humanreadable, Properties machinereadable) {
        PGPNotationDataSP pkt;
        String value;
        String name;
        Enumeration<?> em;
        while (this.removePacket((byte)20) != null) {
        }
        if (humanreadable != null) {
            em = humanreadable.propertyNames();
            while (em.hasMoreElements()) {
                name = (String)em.nextElement();
                value = humanreadable.getProperty(name);
                pkt = new PGPNotationDataSP();
                pkt.setNameData(name);
                pkt.setValueData(value);
                pkt.setHumanReadable(true);
                pkt.setPacketID((byte)20);
                this.addPacket(pkt);
            }
        }
        if (machinereadable != null) {
            em = machinereadable.propertyNames();
            while (em.hasMoreElements()) {
                name = (String)em.nextElement();
                value = machinereadable.getProperty(name);
                pkt = new PGPNotationDataSP();
                pkt.setNameData(name);
                pkt.setValueData(value);
                pkt.setHumanReadable(false);
                pkt.setPacketID((byte)20);
                this.addPacket(pkt);
            }
        }
    }

    public void setPolicyURL(String policyurl) {
        if (policyurl == null) {
            this.removePacket((byte)26);
        } else {
            PGPStringSP pkt = new PGPStringSP();
            pkt.setValue(policyurl);
            pkt.setPacketID((byte)26);
            this.setPacket(pkt);
        }
    }

    public void setRevocable(boolean revocable) {
        if (revocable) {
            this.removePacket((byte)7);
        } else {
            PGPBooleanSP pkt = new PGPBooleanSP();
            pkt.setValue(false);
            pkt.setPacketID((byte)7);
            this.setPacket(pkt);
        }
    }

    public void setTrust(int level, int amount, String regex) {
        PGPSignatureSubPacket pkt;
        if (level == 0 && amount == 0) {
            this.removePacket((byte)5);
        } else {
            pkt = new PGPTrustSP();
            ((PGPTrustSP)pkt).setDepth((byte)level);
            ((PGPTrustSP)pkt).setAmount((byte)amount);
            pkt.setPacketID((byte)5);
            this.setPacket(pkt);
        }
        if (regex == null || level == 0) {
            this.removePacket((byte)6);
        } else {
            pkt = new PGPStringSP();
            ((PGPStringSP)pkt).setValue(regex);
            pkt.setPacketID((byte)6);
            this.setPacket(pkt);
        }
    }
}

