/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.algorithm;

import cryptix.openpgp.algorithm.PGPStringToKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;

public class PGPIteratedAndSaltedS2K
implements PGPStringToKey {
    public byte[] generateAndHash(byte[] passphrase, MessageDigest md, int keysize, DataOutput out, SecureRandom sr) throws IOException {
        byte[] salt = new byte[8];
        sr.nextBytes(salt);
        out.write(salt);
        int count = 150;
        out.write(count);
        return PGPIteratedAndSaltedS2K.toKey(passphrase, md, keysize, salt, count, 3);
    }

    public boolean isSalted() {
        return true;
    }

    public byte[] readAndHash(byte[] passphrase, MessageDigest md, int keysize, DataInput in) throws IOException {
        byte[] salt = new byte[8];
        in.readFully(salt);
        int count = in.readUnsignedByte();
        return PGPIteratedAndSaltedS2K.toKey(passphrase, md, keysize, salt, count, 3);
    }

    static byte[] toKey(byte[] passphrase, MessageDigest md, int keysize, byte[] salt, int countbyte, int specifier) throws IOException {
        int count = specifier == 3 ? 16 + (countbyte & 0xF) << (countbyte >> 4) + 6 : 0;
        byte[] result = new byte[keysize];
        int pos = 0;
        int pass = 0;
        while (pos < keysize) {
            md.reset();
            int done = 0;
            int j = 0;
            while (j < pass) {
                md.update((byte)0);
                ++j;
            }
            if (count < passphrase.length + salt.length) {
                count = passphrase.length + salt.length;
            }
            while (count - done > passphrase.length + salt.length) {
                if (salt.length > 0) {
                    md.update(salt);
                }
                md.update(passphrase);
                done = done + passphrase.length + salt.length;
            }
            int j2 = 0;
            while (j2 < salt.length) {
                if (done < count) {
                    md.update(salt[j2]);
                    ++done;
                }
                ++j2;
            }
            int j3 = 0;
            while (j3 < passphrase.length) {
                if (done < count) {
                    md.update(passphrase[j3]);
                    ++done;
                }
                ++j3;
            }
            byte[] hash = md.digest();
            int size = hash.length;
            if (pos + size > keysize) {
                size = keysize - pos;
            }
            System.arraycopy(hash, 0, result, pos, size);
            pos += size;
            ++pass;
        }
        return result;
    }
}

