/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.algorithm;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPDecryptionFailedException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPEncryptor;
import cryptix.openpgp.algorithm.PGPPublicKeyAlgorithm;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPDataInputStream;
import cryptix.openpgp.io.PGPDataOutputStream;
import cryptix.openpgp.util.PGPMPI;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class PGPRSA
implements PGPSigner,
PGPEncryptor {
    private BigInteger n = null;
    private BigInteger e = null;
    private BigInteger d = null;
    private BigInteger p = null;
    private BigInteger q = null;
    private BigInteger u = null;
    private BigInteger pp = null;
    private BigInteger qq = null;
    private BigInteger s = null;
    private BigInteger m = null;
    private Signature sig;
    private Cipher cipher;

    public PGPRSA() {
    }

    PGPRSA(BigInteger n, BigInteger e) {
        this.n = n;
        this.e = e;
    }

    PGPRSA(BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pp, BigInteger qq, BigInteger u) {
        this.n = n;
        this.e = e;
        this.d = d;
        this.p = p;
        this.q = q;
        this.pp = pp;
        this.qq = qq;
        this.u = u;
    }

    public PGPPublicKeyAlgorithm clonePrivate() {
        return new PGPRSA(this.n, this.e, this.d, this.p, this.q, this.pp, this.qq, this.u);
    }

    public PGPPublicKeyAlgorithm clonePublic() {
        return new PGPRSA(this.n, this.e);
    }

    private boolean compare(BigInteger a, BigInteger b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public void computeSignature() {
        byte[] sigdata;
        try {
            sigdata = this.sig.sign();
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("Signature not initialized");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
        this.s = new BigInteger(1, sigdata);
    }

    public void decodeEncryptedData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.m = in.readMPI();
    }

    public void decodePublicData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.n = in.readMPI();
        this.e = in.readMPI();
    }

    public void decodeSecretData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.d = in.readMPI();
        this.p = in.readMPI();
        this.q = in.readMPI();
        this.u = in.readMPI();
        this.pp = this.d.mod(this.p.subtract(BigInteger.valueOf(1L)));
        this.qq = this.d.mod(this.q.subtract(BigInteger.valueOf(1L)));
    }

    public void decodeSignatureData(PGPDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.s = in.readMPI();
    }

    public byte[] decrypt() throws PGPDecryptionFailedException {
        try {
            this.cipher = Cipher.getInstance("RSA/ECB/PKCS#1", "CryptixCrypto");
            this.cipher.init(2, new PGPRSAPrivateCrtKey());
            int cipherBlockSize = this.cipher.getBlockSize();
            byte[] ct = PGPMPI.toFixedLenByteArray(this.m, cipherBlockSize);
            return this.cipher.doFinal(ct);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            throw new RuntimeException("Not allowed to use RSA. Perhaps you need to download the Unlimited Strength Jurisdiction Policy Files from the Sun website? " + se);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PGPDecryptionFailedException("Data larger than key. Wrong key used?");
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPDecryptionFailedException("Decrypted data != PKCS#1. Wrong key used?");
        }
        catch (IllegalBlockSizeException ibs) {
            ibs.printStackTrace();
            throw new InternalError("Illegal blocksize");
        }
        catch (InvalidKeyException ivk) {
            ivk.printStackTrace();
            throw new InternalError("Key was invalid");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("RSA algorithm not found. Provider problem?");
        }
        catch (NoSuchPaddingException nsp) {
            nsp.printStackTrace();
            throw new RuntimeException("Couldn't use PKCS#1 padding. Provider problem?");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public void encodeEncryptedData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.m);
    }

    public void encodePublicData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.n);
        out.writeMPI(this.e);
    }

    public void encodeSecretData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.d);
        out.writeMPI(this.p);
        out.writeMPI(this.q);
        out.writeMPI(this.u);
    }

    public void encodeSignatureData(PGPDataOutputStream out) throws IOException {
        out.writeMPI(this.s);
    }

    public byte[] encodeV3FingerprintData() {
        byte[] modbytes = this.n.toByteArray();
        byte[] expbytes = this.e.toByteArray();
        int modlen = modbytes.length;
        int explen = expbytes.length;
        if (modbytes[0] == 0) {
            --modlen;
        }
        if (expbytes[0] == 0) {
            --explen;
        }
        byte[] temp = new byte[modlen + explen];
        System.arraycopy(modbytes, modbytes.length - modlen, temp, 0, modlen);
        System.arraycopy(expbytes, expbytes.length - explen, temp, modlen, explen);
        return temp;
    }

    public byte[] encodeV3KeyIDData() {
        byte[] bytes = this.n.toByteArray();
        byte[] temp = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, temp, 0, 8);
        return temp;
    }

    public void encrypt(byte[] data, SecureRandom sr) {
        try {
            this.cipher = Cipher.getInstance("RSA/ECB/PKCS#1", "CryptixCrypto");
            this.cipher.init(1, (Key)new PGPRSAPublicKey(), sr);
            byte[] encrypted = this.cipher.doFinal(data);
            this.m = new BigInteger(1, encrypted);
        }
        catch (SecurityException se) {
            se.printStackTrace(System.err);
            throw new RuntimeException("Not allowed to use RSA. Perhaps you need to download the Unlimited Strength Jurisdiction Policy Files from the Sun website? " + se);
        }
        catch (InvalidKeyException ivk) {
            ivk.printStackTrace();
            throw new InternalError("Key was invalid:");
        }
        catch (IllegalBlockSizeException ibs) {
            ibs.printStackTrace();
            throw new InternalError("Illegal blocksize");
        }
        catch (BadPaddingException bp) {
            bp.printStackTrace();
            throw new InternalError("Bad padding");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("RSA algorithm not found. Provider problem?");
        }
        catch (NoSuchPaddingException nsp) {
            nsp.printStackTrace();
            throw new RuntimeException("Couldn't use PKCS#1 padding. Provider problem?");
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGPRSA) {
            PGPRSA objx = (PGPRSA)obj;
            return objx.equals(this.n, this.e, this.d, this.p, this.q, this.pp, this.qq, this.u);
        }
        return false;
    }

    boolean equals(BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pp, BigInteger qq, BigInteger u) {
        return this.compare(this.n, n) && this.compare(this.e, e) && this.compare(this.d, d) && this.compare(this.p, p) && this.compare(this.q, q) && this.compare(this.pp, pp) && this.compare(this.qq, qq) && this.compare(this.u, u);
    }

    public void forgetSecretData() {
        this.d = null;
        this.p = null;
        this.q = null;
        this.pp = null;
        this.qq = null;
        this.u = null;
    }

    public void generateKeyPair(int keysize, SecureRandom sr) {
        KeyPairGenerator kpg;
        try {
            kpg = KeyPairGenerator.getInstance("RSA", "CryptixCrypto");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Cannot find RSA implementation");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
        kpg.initialize(keysize, sr);
        KeyPair kp = ((KeyPairGeneratorSpi)kpg).generateKeyPair();
        this.n = ((RSAPublicKey)kp.getPublic()).getModulus();
        this.e = ((RSAPublicKey)kp.getPublic()).getPublicExponent();
        this.d = ((RSAPrivateCrtKey)kp.getPrivate()).getPrivateExponent();
        this.p = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeP();
        this.q = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeQ();
        this.pp = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeExponentP();
        this.qq = ((RSAPrivateCrtKey)kp.getPrivate()).getPrimeExponentQ();
        this.u = ((RSAPrivateCrtKey)kp.getPrivate()).getCrtCoefficient();
        if (this.p.compareTo(this.q) == 1) {
            BigInteger t = this.p;
            this.p = this.q;
            this.q = t;
            t = this.pp;
            this.pp = this.qq;
            this.qq = t;
        }
        this.u = this.p.modInverse(this.q);
    }

    public int getBitLength() {
        return this.n.bitLength();
    }

    public RSAPrivateCrtKey getRSAPrivateCrtKey() {
        return new PGPRSAPrivateCrtKey();
    }

    public RSAPublicKey getRSAPublicKey() {
        return new PGPRSAPublicKey();
    }

    public int hashCode() {
        int hash = 0;
        if (this.n != null) {
            hash ^= this.n.hashCode();
        }
        if (this.e != null) {
            hash ^= this.e.hashCode();
        }
        if (this.d != null) {
            hash ^= this.d.hashCode();
        }
        return hash;
    }

    public void initSign(int hashID, PGPAlgorithmFactory factory) {
        try {
            String h = factory.getHashAlgorithmString(hashID);
            this.sig = Signature.getInstance(String.valueOf(h) + "withRSA", "CryptixCrypto");
            this.sig.initSign(new PGPRSAPrivateCrtKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException("InvalidKeyException");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("RSA algorithm not found.");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public void initVerify(int hashID, PGPAlgorithmFactory factory) {
        try {
            String h = factory.getHashAlgorithmString(hashID);
            this.sig = Signature.getInstance(String.valueOf(h) + "withRSA", "CryptixCrypto");
            this.sig.initVerify(new PGPRSAPublicKey());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException("InvalidKeyException");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("RSA algorithm not found.");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("Cryptix JCE provider not found.");
        }
    }

    public boolean signatureEquals(PGPSigner obj) {
        if (obj instanceof PGPRSA) {
            PGPRSA objx = (PGPRSA)obj;
            return objx.signatureEquals(this.s);
        }
        return false;
    }

    boolean signatureEquals(BigInteger s) {
        return this.compare(this.s, s);
    }

    public String toString() {
        return "RSA";
    }

    public void update(byte[] data) {
        try {
            this.sig.update(data);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("Signature not initialized");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    public void update(byte[] data, int offset, int len) {
        try {
            this.sig.update(data, offset, len);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("Signature not initialized");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    public boolean verifySignature() {
        byte[] sigdata = PGPMPI.toFixedLenByteArray(this.s, (this.n.bitLength() + 7) / 8);
        try {
            return this.sig.verify(sigdata);
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException("SignatureException");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Signature not initialized");
        }
    }

    private class PGPRSAPublicKey
    implements RSAPublicKey {
        PGPRSAPublicKey() {
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public BigInteger getModulus() {
            return PGPRSA.this.n;
        }

        public BigInteger getPublicExponent() {
            return PGPRSA.this.e;
        }
    }

    private class PGPRSAPrivateCrtKey
    implements RSAPrivateCrtKey {
        PGPRSAPrivateCrtKey() {
        }

        public String getAlgorithm() {
            return "RSA";
        }

        public BigInteger getCrtCoefficient() {
            return PGPRSA.this.u;
        }

        public byte[] getEncoded() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public BigInteger getModulus() {
            return PGPRSA.this.n;
        }

        public BigInteger getPrimeExponentP() {
            return PGPRSA.this.qq;
        }

        public BigInteger getPrimeExponentQ() {
            return PGPRSA.this.pp;
        }

        public BigInteger getPrimeP() {
            return PGPRSA.this.q;
        }

        public BigInteger getPrimeQ() {
            return PGPRSA.this.p;
        }

        public BigInteger getPrivateExponent() {
            return PGPRSA.this.d;
        }

        public BigInteger getPublicExponent() {
            return PGPRSA.this.e;
        }
    }
}

