/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPLengthDataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PGPPacketDataInputStream
extends PGPLengthDataInputStream {
    private boolean isFinal = false;
    private boolean isIndeterminate = false;
    private boolean isPartial = false;
    private boolean old;
    private int lentype;

    public PGPPacketDataInputStream(InputStream in, boolean old, int lentype) {
        super(in);
        if (old && (lentype > 3 || lentype < 0)) {
            throw new IllegalArgumentException("Illegal length type");
        }
        this.old = old;
        this.lentype = lentype;
        if (old && lentype == 3) {
            this.isIndeterminate = true;
        }
    }

    protected long getNewChunkLength(InputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        long chunkLength;
        if (this.isFinal) {
            chunkLength = 0L;
        } else if (this.isIndeterminate) {
            chunkLength = in.available();
        } else {
            long len = this.readBodyLength();
            if (len < -1L) {
                chunkLength = 1 << (int)(-len & 0x1FL);
                this.isPartial = true;
            } else {
                chunkLength = len;
                this.isFinal = true;
            }
        }
        return chunkLength;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    private long readBodyLength() throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        if (this.old) {
            switch (this.lentype) {
                case 0: {
                    return this.readUnsignedByte();
                }
                case 1: {
                    return this.readUnsignedShort();
                }
                case 2: {
                    return this.readUnsignedInt();
                }
                case 3: {
                    return -1L;
                }
            }
            throw new InternalError("lentype != 0, 1, 2 or 3");
        }
        short octet1 = this.readUnsignedByte();
        if (octet1 < 192) {
            return octet1;
        }
        if (octet1 >= 192 && octet1 < 224) {
            return (octet1 - 192 << 8) + this.readUnsignedByte() + 192;
        }
        if (octet1 == 255) {
            return this.readUnsignedInt();
        }
        return -octet1;
    }
}

