/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPLengthDataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PGPSignatureDataInputStream
extends PGPLengthDataInputStream {
    private boolean isFinal = false;

    public PGPSignatureDataInputStream(InputStream in) {
        super(in);
    }

    protected long getNewChunkLength(InputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        long chunkLength;
        if (this.isFinal) {
            chunkLength = 0L;
        } else {
            chunkLength = this.readBodyLength(in);
            this.isFinal = true;
        }
        return chunkLength;
    }

    private long readBodyLength(InputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        int octet1 = in.read();
        if (octet1 < 192) {
            return octet1;
        }
        if (octet1 >= 192 && octet1 < 255) {
            return (octet1 - 192 << 8) + in.read() + 192;
        }
        return ((long)in.read() << 24) + (long)(in.read() << 16) + (long)(in.read() << 8) + (long)in.read();
    }
}

