/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPOnePassSignaturePacket
extends PGPPacket {
    private byte version;
    private byte type;
    private byte hashid;
    private byte algid;
    private byte[] keyid;
    private boolean nested;

    public PGPOnePassSignaturePacket() {
    }

    public PGPOnePassSignaturePacket(byte type, byte hashid, byte algid, byte[] keyid, boolean nested) {
        this.version = (byte)3;
        this.type = type;
        this.hashid = hashid;
        this.algid = algid;
        this.keyid = keyid;
        this.nested = nested;
    }

    public PGPOnePassSignaturePacket(String id, boolean nested) {
        this(id, nested, PGPAlgorithmFactory.getDefaultInstance());
    }

    public PGPOnePassSignaturePacket(String id, boolean nested, PGPAlgorithmFactory factory) {
        this.version = (byte)-1;
        this.nested = nested;
        this.hashid = (byte)factory.getHashAlgorithmIDFromTextName(id);
    }

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        this.version = in.readByte();
        if (this.version != 3) {
            in.readByteArray();
            throw new PGPDataFormatException("Unsupported version");
        }
        this.type = in.readByte();
        this.hashid = in.readByte();
        this.algid = in.readByte();
        this.keyid = new byte[8];
        in.readFully(this.keyid);
        this.nested = in.readBoolean() ^ true;
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        if (this.version == -1) {
            throw new IllegalStateException("Cannot encode a plaintext OnePassSignaturePacket in binary format.");
        }
        out.writeByte(this.version);
        out.writeByte(this.type);
        out.writeByte(this.hashid);
        out.writeByte(this.algid);
        out.writeFully(this.keyid);
        out.writeBoolean(this.nested ^ true);
    }

    public boolean equals(Object ssp) {
        if (ssp instanceof PGPOnePassSignaturePacket) {
            PGPOnePassSignaturePacket that = (PGPOnePassSignaturePacket)ssp;
            boolean equal = PGPCompare.equals(this.type, that.type) && PGPCompare.equals(this.algid, that.algid) && PGPCompare.equals(this.hashid, that.hashid) && PGPCompare.equals(this.version, that.version) && PGPCompare.equals(this.keyid, that.keyid) && PGPCompare.equals(this.nested, that.nested);
            return equal;
        }
        return false;
    }

    public byte getAlgorithmID() {
        if (this.version == -1) {
            throw new IllegalStateException("Plaintext sig");
        }
        return this.algid;
    }

    public byte getHashID() {
        return this.hashid;
    }

    public byte[] getKeyID() {
        if (this.version == -1) {
            throw new IllegalStateException("Plaintext sig");
        }
        return this.keyid;
    }

    public byte getType() {
        if (this.version == -1) {
            throw new IllegalStateException("Plaintext sig");
        }
        return this.type;
    }

    public byte getVersion() {
        if (this.version == -1) {
            throw new IllegalStateException("Plaintext sig");
        }
        return this.version;
    }

    public boolean isNested() {
        return this.nested;
    }
}

