/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.packet.PGPPacketFactory;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPPublicSubKeyPacket;
import cryptix.openpgp.packet.PGPSecretKeyPacket;
import cryptix.openpgp.packet.PGPSecretSubKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.packet.PGPTrustPacket;
import cryptix.openpgp.packet.PGPUserIDPacket;
import cryptix.openpgp.provider.PGPCertificateImpl;
import cryptix.openpgp.provider.PGPKeyBundleImpl;
import cryptix.openpgp.provider.PGPUserIDPrincipal;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyBundleException;
import cryptix.pki.KeyBundleFactorySpi;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Vector;

public class PGPKeyBundleFactory
extends KeyBundleFactorySpi {
    private static final int NO_KEY = 0;
    private static final int MAIN_KEY = 1;
    private static final int USERID = 2;
    private static final int SUB_KEY = 3;
    private static final int SUB_KEY_SIG = 4;
    private static final int UNKNOWN = 4;

    public KeyBundle engineGenerateEmptyKeyBundle() throws KeyBundleException {
        return new PGPKeyBundleImpl();
    }

    public KeyBundle engineGenerateKeyBundle(InputStream in) throws KeyBundleException, IOException {
        Object result = PGPKeyBundleFactory.helper(in, true);
        if (result instanceof Vector) {
            return (KeyBundle)((AbstractList)((Vector)result)).iterator().next();
        }
        return (KeyBundle)result;
    }

    public Collection engineGenerateKeyBundles(InputStream in) throws KeyBundleException, IOException {
        return (Collection)PGPKeyBundleFactory.helper(in, false);
    }

    /*
     * Unable to fully structure code
     */
    static Object helper(InputStream in, boolean onlyOne) throws KeyBundleException, IOException {
        pf = PGPPacketFactory.getDefaultInstance();
        af = PGPAlgorithmFactory.getDefaultInstance();
        pkt = null;
        lastUserID = null;
        lastCertMap = null;
        lastPublicSubkey = null;
        lastPrivateSubkey = null;
        bundle = new PGPKeyBundleImpl();
        result = new Vector<PGPKeyBundleImpl>();
        state = 0;
        secret = false;
        if (in.available() != 0) ** GOTO lbl105
        if (onlyOne) {
            return null;
        }
        return result;
lbl-1000:
        // 1 sources

        {
            try {
                if (onlyOne) {
                    in.mark(16384);
                }
                pkt = pf.readPacket(in, af);
            }
            catch (PGPDataFormatException v0) {
            }
            catch (PGPFatalDataFormatException fdfe) {
                throw new KeyBundleException(String.valueOf(String.valueOf(fdfe)));
            }
            if (pkt instanceof PGPPublicKeyPacket) {
                if (state != 0) {
                    if (onlyOne) {
                        in.reset();
                        return bundle;
                    }
                    result.add(bundle);
                    bundle = new PGPKeyBundleImpl();
                }
                state = 1;
                secret = false;
                name = "Signing/" + af.getPublicKeyName(((PGPPublicKeyPacket)pkt).getAlgorithmID());
                bundle.mainkey = new PGPPublicKey((PGPPublicKeyPacket)pkt, name);
                continue;
            }
            if (pkt instanceof PGPSecretKeyPacket) {
                if (state != 0) {
                    result.add(bundle);
                    bundle = new PGPKeyBundleImpl();
                }
                state = 1;
                secret = true;
                name = "Signing/" + af.getPublicKeyName(((PGPSecretKeyPacket)pkt).getAlgorithmID());
                bundle.mainkey = new PGPPublicKey(((PGPSecretKeyPacket)pkt).clonePublic(), name);
                bundle.privpkt = (PGPSecretKeyPacket)pkt;
                continue;
            }
            if (pkt instanceof PGPUserIDPacket) {
                if (state == 0 || state == 3) {
                    throw new KeyBundleException("UserID packet found at invalid location");
                }
                state = 2;
                lastUserID = new PGPUserIDPrincipal((PGPUserIDPacket)pkt);
                lastCertMap = new Vector<PGPCertificateImpl>();
                bundle.principals.add(lastUserID);
                bundle.principalsToCertificates.put(lastUserID, lastCertMap);
                continue;
            }
            if (pkt instanceof PGPPublicSubKeyPacket) {
                if (state == 0) {
                    throw new KeyBundleException("Subkey found at invalid location");
                }
                state = 3;
                name = "Encryption/" + af.getPublicKeyName(((PGPPublicSubKeyPacket)pkt).getAlgorithmID());
                lastPublicSubkey = new PGPPublicKey((PGPPublicSubKeyPacket)pkt, name);
                lastPrivateSubkey = null;
                bundle.subkeys.add(lastPublicSubkey);
                continue;
            }
            if (pkt instanceof PGPSecretSubKeyPacket) {
                if (state == 0) {
                    throw new KeyBundleException("Subkey found at invalid location");
                }
                if (!secret) {
                    throw new KeyBundleException("Expected public subkey, found private subkey");
                }
                state = 3;
                name = "Encryption/" + af.getPublicKeyName(((PGPSecretSubKeyPacket)pkt).getAlgorithmID());
                lastPublicSubkey = new PGPPublicKey(((PGPSecretSubKeyPacket)pkt).clonePublicSub(), name);
                lastPrivateSubkey = (PGPSecretSubKeyPacket)pkt;
                bundle.subkeys.add(lastPublicSubkey);
                bundle.privSubkeys.put(lastPublicSubkey, lastPrivateSubkey);
                continue;
            }
            if (pkt instanceof PGPSignaturePacket) {
                if (state == 0) {
                    throw new KeyBundleException("Signature found at invalid location");
                }
                if (state == 1) {
                    bundle.directKeySigs.add(pkt);
                    continue;
                }
                if (state == 2) {
                    cert = new PGPCertificateImpl((PGPSignaturePacket)pkt, lastUserID, bundle.mainkey);
                    bundle.certificates.add(cert);
                    lastCertMap.add(cert);
                    continue;
                }
                if (state != 3) continue;
                state = 4;
                bundle.subkeyBindingSigs.put(lastPublicSubkey, pkt);
                continue;
            }
            if (pkt instanceof PGPTrustPacket) continue;
            state = 4;
lbl105:
            // 12 sources

            ** while (in.available() > 0)
        }
lbl106:
        // 1 sources

        result.add(bundle);
        return result;
    }
}

