/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPKey;
import cryptix.openpgp.packet.PGPKeyPacket;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPPublicSubKeyPacket;
import cryptix.openpgp.packet.PGPSecretKeyPacket;
import cryptix.openpgp.packet.PGPSecretSubKeyPacket;
import cryptix.openpgp.provider.PGPKeyIDImpl;
import cryptix.pki.KeyID;
import cryptix.pki.KeyIDFactorySpi;
import java.security.InvalidKeyException;
import java.security.Key;

public class PGPKeyIDFactory
extends KeyIDFactorySpi {
    static KeyID convert(Key key) throws InvalidKeyException {
        if (!(key instanceof PGPKey)) {
            throw new InvalidKeyException("Not an instance of PGPKey.");
        }
        PGPKeyPacket packet = ((PGPKey)key).getPacket();
        if (packet instanceof PGPPublicKeyPacket || packet instanceof PGPPublicSubKeyPacket) {
            return new PGPKeyIDImpl(packet);
        }
        if (packet instanceof PGPSecretKeyPacket) {
            return new PGPKeyIDImpl(packet.clonePublic());
        }
        if (packet instanceof PGPSecretSubKeyPacket) {
            return new PGPKeyIDImpl(packet.clonePublicSub());
        }
        throw new InvalidKeyException("No valid key packet found.");
    }

    public KeyID engineGenerateKeyID(Key key) throws InvalidKeyException {
        return PGPKeyIDFactory.convert(key);
    }
}

