/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.LiteralMessage;
import cryptix.message.MessageException;
import cryptix.openpgp.packet.PGPLiteralDataPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public class PGPLiteralMessageImpl
extends LiteralMessage {
    private final PGPLiteralDataPacket pkt;

    public PGPLiteralMessageImpl(PGPLiteralDataPacket pkt) {
        super("OpenPGP");
        this.pkt = pkt;
    }

    public Object getAttribute(String name) throws IllegalArgumentException, MessageException {
        if (name.equals("filename")) {
            return this.pkt.getFileName();
        }
        throw new IllegalArgumentException("Attribute [" + name + "] not supported");
    }

    public byte[] getBinaryData() throws UnsupportedOperationException, MessageException {
        return this.pkt.getBinaryData();
    }

    public InputStream getBinaryDataInputStream() throws UnsupportedOperationException, MessageException {
        return new ByteArrayInputStream(this.pkt.getBinaryData());
    }

    public int getDataType() {
        if (this.pkt.isBinary()) {
            return 1;
        }
        if (this.pkt.isText()) {
            return 2;
        }
        if (this.pkt.isLocal()) {
            return 0;
        }
        throw new RuntimeException("PANIC");
    }

    public byte[] getEncoded() throws MessageException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.pkt.encode(baos);
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IOException in ByteArrayOutputStream - " + ioe);
        }
    }

    public String getTextData() throws UnsupportedOperationException, MessageException {
        return this.pkt.getTextData();
    }

    public Reader getTextDataReader() throws UnsupportedOperationException, MessageException {
        return new StringReader(this.pkt.getTextData());
    }
}

