/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.stream.LiteralMessageOutputStreamSpi;
import cryptix.message.stream.MessageOutputStream;
import cryptix.message.stream.MessageStreamException;
import cryptix.openpgp.provider.PGPSignedMessageOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;

public class PGPLiteralMessageOutputStream
implements LiteralMessageOutputStreamSpi {
    private OutputStream out;
    private PGPSignedMessageOutputStream sigout;
    private int nodata = 0;
    private SecureRandom sr;
    private boolean nodatawritten = true;
    private byte[] buf = new byte[8192];
    private int partialLengthByte = 237;
    private int bufoffset = 0;

    public void engineClose() throws IOException, MessageStreamException {
        if (this.nodatawritten) {
            if (this.sigout != null) {
                this.sigout.writeNoData(203);
            } else {
                this.out.write(203);
            }
        }
        if (this.sigout != null) {
            if (this.bufoffset < 192) {
                this.sigout.writeNoData((byte)this.bufoffset);
            } else if (this.bufoffset < 8384) {
                this.sigout.writeNoData(192 + (byte)(this.bufoffset - 192 >> 8));
                this.sigout.writeNoData((byte)(this.bufoffset - 192));
            } else {
                this.sigout.writeNoData(255);
                this.sigout.writeNoData((byte)(this.bufoffset >> 24));
                this.sigout.writeNoData((byte)(this.bufoffset >> 16));
                this.sigout.writeNoData((byte)(this.bufoffset >> 8));
                this.sigout.writeNoData((byte)this.bufoffset);
            }
        } else if (this.bufoffset < 192) {
            this.out.write((byte)this.bufoffset);
        } else if (this.bufoffset < 8384) {
            this.out.write(192 + (byte)(this.bufoffset - 192 >> 8));
            this.out.write((byte)(this.bufoffset - 192));
        } else {
            this.out.write(255);
            this.out.write((byte)(this.bufoffset >> 24));
            this.out.write((byte)(this.bufoffset >> 16));
            this.out.write((byte)(this.bufoffset >> 8));
            this.out.write((byte)this.bufoffset);
        }
        if (this.sigout != null && this.nodata != 0) {
            int i = 0;
            while (i < this.nodata) {
                this.sigout.writeNoData(this.buf[i]);
                ++i;
            }
            this.out.write(this.buf, this.nodata, this.bufoffset - this.nodata);
        } else {
            this.out.write(this.buf, 0, this.bufoffset);
        }
        this.out.close();
    }

    public void engineFlush() throws IOException, MessageStreamException {
        this.out.flush();
    }

    public void engineInit(OutputStream out, SecureRandom sr) throws IllegalStateException, IOException, MessageStreamException {
        if (this.out != null) {
            throw new IllegalStateException("Already called init before");
        }
        if (out == null) {
            throw new IllegalArgumentException("Outputstream cannot be null");
        }
        this.out = out;
        this.sr = sr;
        this.sigout = null;
        if (out instanceof MessageOutputStream && ((MessageOutputStream)out).getSpi() instanceof PGPSignedMessageOutputStream) {
            this.sigout = (PGPSignedMessageOutputStream)((MessageOutputStream)out).getSpi();
        }
        this.buf[0] = 98;
        this.buf[1] = 0;
        this.buf[2] = 0;
        this.buf[3] = 0;
        this.buf[4] = 0;
        this.buf[5] = 0;
        this.bufoffset = 6;
        this.nodata = 6;
    }

    public void engineSetAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageStreamException {
        throw new IllegalArgumentException("No attributes supported");
    }

    public void engineWrite(int b) throws IOException, MessageStreamException {
        byte[] b1 = new byte[]{(byte)b};
        this.engineWrite(b1, 0, 1);
    }

    public void engineWrite(byte[] b) throws IOException, MessageStreamException {
        this.engineWrite(b, 0, b.length);
    }

    public void engineWrite(byte[] b, int off, int len) throws IOException, MessageStreamException {
        if (this.out == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        if (this.nodatawritten) {
            if (this.sigout != null) {
                this.sigout.writeNoData(203);
            } else {
                this.out.write(203);
            }
            this.nodatawritten = false;
        }
        while (this.bufoffset + len > this.buf.length) {
            System.arraycopy(b, off, this.buf, this.bufoffset, this.buf.length - this.bufoffset);
            if (this.sigout != null) {
                this.sigout.writeNoData(this.partialLengthByte);
            } else {
                this.out.write(this.partialLengthByte);
            }
            if (this.sigout != null && this.nodata != 0) {
                int i = 0;
                while (i < this.nodata) {
                    this.sigout.writeNoData(this.buf[i]);
                    ++i;
                }
                this.out.write(this.buf, this.nodata, this.buf.length - this.nodata);
                this.nodata = 0;
            } else {
                this.out.write(this.buf, 0, this.buf.length);
            }
            off += this.buf.length - this.bufoffset;
            len -= this.buf.length - this.bufoffset;
            this.bufoffset = 0;
        }
        System.arraycopy(b, off, this.buf, this.bufoffset, len);
        this.bufoffset += len;
    }
}

