/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPBooleanSP
extends PGPSignatureSubPacket {
    private boolean value = false;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte b = in.readByte();
        if (b == 0) {
            this.setValue(false);
        } else if (b == 1) {
            this.setValue(true);
        } else {
            throw new PGPDataFormatException("Invalid packet value");
        }
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getValue()) {
            out.writeByte((byte)1);
        } else {
            out.writeByte((byte)0);
        }
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPBooleanSP)) {
            return false;
        }
        PGPBooleanSP that = (PGPBooleanSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getValue(), that.getValue());
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }
}

