/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public abstract class PGPFlagsSP
extends PGPSignatureSubPacket {
    private byte[] value;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] value = in.readByteArray();
        if (value.length == 0) {
            throw new PGPDataFormatException("No data found.");
        }
        this.setValue(value);
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getValue() != null) {
            out.writeFully(this.getValue());
        } else {
            out.writeByte((byte)0);
        }
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPFlagsSP)) {
            return false;
        }
        PGPFlagsSP that = (PGPFlagsSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getValue(), that.getValue());
    }

    public boolean getFlag(int location, int flag) {
        return (this.getValue(location + 1)[location] & flag) != 0;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getValue(int size) {
        byte[] result = new byte[size];
        int i = 0;
        while (i < size) {
            result[i] = 0;
            ++i;
        }
        if (this.value != null) {
            if (size <= this.value.length) {
                System.arraycopy(this.value, 0, result, 0, size);
            } else {
                System.arraycopy(this.value, 0, result, 0, this.value.length);
            }
        }
        return result;
    }

    public void setFlag(int location, int flag, boolean set) {
        if (this.value == null) {
            this.value = new byte[location + 1];
            int i = 0;
            while (i < location + 1) {
                this.value[i] = 0;
                ++i;
            }
        }
        if (this.value.length < location) {
            this.value = this.getValue(location + 1);
        }
        this.value[location] = set ? (byte)(this.value[location] | flag) : (byte)(this.value[location] & 255 - flag);
    }

    public void setValue(byte[] value) {
        if (value.length == 0) {
            throw new IllegalArgumentException("Array size == 0");
        }
        this.value = value;
    }
}

