/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PGPSignatureSubPacket {
    private int packetid = 256;
    private boolean critical = false;

    public void decode(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.decodeBody(in);
        in.close();
    }

    protected abstract void decodeBody(PGPSignatureDataInputStream var1) throws IOException, PGPDataFormatException, PGPFatalDataFormatException;

    public void encode(OutputStream out) throws IOException {
        if (this.packetid == 256) {
            throw new IllegalStateException("PacketID not set.");
        }
        PGPSignatureDataOutputStream sdos = new PGPSignatureDataOutputStream(out, this.getPacketID());
        this.encodeBody(sdos);
        sdos.close();
    }

    protected abstract void encodeBody(PGPSignatureDataOutputStream var1) throws IOException;

    public abstract boolean equals(Object var1);

    public boolean getCritical() {
        return this.critical;
    }

    public byte getPacketID() {
        return (byte)this.packetid;
    }

    public int hashCode() {
        return this.getPacketID();
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public void setPacketID(byte id) {
        this.packetid = id;
    }
}

