/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.util;

import cryptix.openpgp.util.PGPBase64;
import cryptix.openpgp.util.PGPCRC;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PGPArmoury {
    public static final String TYPE_PUBLIC_KEY = "PGP PUBLIC KEY BLOCK";
    public static final String TYPE_SECRET_KEY = "PGP PRIVATE KEY BLOCK";
    private Properties headers;
    private Properties clearheaders;
    private byte[] clearText;
    private byte[] payload;
    private String type;

    public PGPArmoury(String armouredText) throws IllegalArgumentException {
        this.headers = PGPArmoury.getDefaultHeaders();
        this.clearheaders = new Properties();
        this.parse(armouredText);
    }

    public PGPArmoury(Properties headers, byte[] payload) {
        this(headers, payload, "PGP MESSAGE");
    }

    public PGPArmoury(Properties headers, byte[] payload, String type) {
        this.headers = PGPArmoury.addMissingHeaders(headers);
        this.clearheaders = new Properties();
        this.clearText = null;
        this.payload = payload;
        this.type = type;
    }

    public PGPArmoury(Properties headers, byte[] clearText, byte[] signature) {
        this.headers = PGPArmoury.addMissingHeaders(headers);
        this.clearheaders = new Properties();
        this.clearText = clearText;
        this.payload = signature;
    }

    public PGPArmoury(byte[] payload) {
        this(PGPArmoury.getDefaultHeaders(), payload, "PGP MESSAGE");
    }

    public PGPArmoury(byte[] payload, String type) {
        this(PGPArmoury.getDefaultHeaders(), payload, type);
    }

    public PGPArmoury(byte[] text, byte[] signature) throws IllegalArgumentException {
        this(PGPArmoury.getDefaultHeaders(), text, signature);
    }

    private static Properties addMissingHeaders(Properties headers) {
        String version = headers.getProperty("Version", "Cryptix OpenPGP 0.20050418");
        ((Hashtable)headers).put("Version", version);
        return headers;
    }

    public static String armour(byte[] bytes) {
        String mainEncodedString = PGPBase64.encode(bytes);
        int crcInt = PGPCRC.checksum(bytes);
        byte[] crcBytes = new byte[]{(byte)(crcInt >> 16), (byte)(crcInt >> 8), (byte)crcInt};
        String crcEncodedString = PGPBase64.encode(crcBytes);
        return String.valueOf(mainEncodedString) + "=" + crcEncodedString;
    }

    public static String canonicalize(String s) {
        int pos = 0;
        String result = "";
        while (pos < s.length()) {
            int n;
            int r = s.indexOf("\r", pos);
            if (r == -1) {
                r = s.length();
            }
            if ((n = s.indexOf("\n", pos)) == -1) {
                n = s.length();
            }
            if (r < n) {
                result = String.valueOf(result) + PGPArmoury.removeTrailingWhitespace(s.substring(pos, r)) + "\r\n";
                pos = r + 1;
                if (n != r + 1) continue;
                ++pos;
                continue;
            }
            result = String.valueOf(result) + PGPArmoury.removeTrailingWhitespace(s.substring(pos, n)) + "\r\n";
            pos = n + 1;
            if (r != n + 1) continue;
            ++pos;
        }
        return result;
    }

    public static String dashProtect(String s) {
        int startPos = 0;
        int len = s.length();
        StringBuffer buffer = new StringBuffer(2 * len);
        while (startPos < len) {
            int nextPos = s.indexOf("\r\n", startPos) + 2;
            if (nextPos == 1) {
                nextPos = len;
            }
            if (s.startsWith("-", startPos) || s.startsWith("From ", startPos) || s.startsWith(".\r\n", startPos)) {
                buffer.append("- ");
            }
            buffer.append(s.substring(startPos, nextPos));
            startPos = nextPos;
        }
        return buffer.toString();
    }

    public static String fixLineEndings(String txt, String eol) {
        char[] result = new char[txt.length() * 2];
        int pos = 0;
        int i = 0;
        while (i < txt.length()) {
            int j;
            char c = txt.charAt(i);
            if (c == '\r') {
                j = 0;
                while (j < eol.length()) {
                    result[pos] = eol.charAt(j);
                    ++pos;
                    ++j;
                }
                if (i + 1 < txt.length() && txt.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else if (c == '\n') {
                j = 0;
                while (j < eol.length()) {
                    result[pos] = eol.charAt(j);
                    ++pos;
                    ++j;
                }
                if (i + 1 < txt.length() && txt.charAt(i + 1) == '\r') {
                    ++i;
                }
            } else {
                result[pos] = c;
                ++pos;
            }
            ++i;
        }
        return new String(result, 0, pos);
    }

    public byte[] getClearText() {
        return this.clearText;
    }

    private static Properties getDefaultHeaders() {
        return PGPArmoury.addMissingHeaders(new Properties());
    }

    public Properties getHeaders() {
        return this.headers;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    private String headersToString(Properties head) {
        StringBuffer s = new StringBuffer(256);
        Enumeration<?> e = head.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.length() <= 0) continue;
            String value = head.getProperty(name);
            s.append(name);
            s.append(": ");
            int vPos = s.length();
            s.append(value);
            s.setCharAt(vPos, Character.toUpperCase(value.charAt(0)));
            s.append("\r\n");
        }
        s.append("\r\n");
        return new String(s);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Armour:   PGPArmoury BinFile AscFile Identifier");
            System.out.println("Example:  PGPArmoury key.pgp key.asc PGP PUBLIC KEY");
            System.out.println();
            System.out.println("Unarmour: PGPArmoury AscFile BinFile");
            System.out.println("Example:  PGPArmoury key.asc key.pgp");
        } else if (args.length == 2) {
            FileInputStream fis = new FileInputStream(args[0]);
            DataInputStream dis = new DataInputStream(fis);
            FileOutputStream fos = new FileOutputStream(args[1]);
            DataOutputStream dos = new DataOutputStream(fos);
            byte[] armoured = new byte[fis.available()];
            dis.readFully(armoured);
            String armouredString = new String(armoured, "UTF-8");
            PGPArmoury armoury = new PGPArmoury(armouredString);
            byte[] unarmoured = armoury.getPayload();
            dos.write(unarmoured);
        } else {
            FileInputStream fis = new FileInputStream(args[0]);
            DataInputStream dis = new DataInputStream(fis);
            FileOutputStream fos = new FileOutputStream(args[1]);
            DataOutputStream dos = new DataOutputStream(fos);
            byte[] unarmoured = new byte[fis.available()];
            dis.readFully(unarmoured);
            String type = "";
            int i = 2;
            while (i < args.length) {
                if (!type.equals("")) {
                    type = String.valueOf(type) + " ";
                }
                type = String.valueOf(type) + args[i];
                ++i;
            }
            PGPArmoury armoury = new PGPArmoury(unarmoured, type);
            String armouredString = armoury.toString();
            byte[] armoured = armouredString.getBytes("UTF-8");
            dos.write(armoured);
        }
    }

    public void parse(String armouredMessage) throws IllegalArgumentException {
        int propPos;
        String propString;
        int msgPos;
        int startPos = (armouredMessage = PGPArmoury.fixLineEndings(armouredMessage, "\r\n")).indexOf("-----BEGIN PGP SIGNED MESSAGE-----\r\n");
        if (startPos != -1) {
            int sigPos = armouredMessage.indexOf("\r\n-----BEGIN PGP SIGNATURE-----\r\n", startPos += 36);
            msgPos = armouredMessage.indexOf("\r\n\r\n", startPos - 2);
            if (msgPos > startPos) {
                propString = armouredMessage.substring(startPos, msgPos);
                this.stringToHeaders(propString, this.clearheaders);
            }
            String text = armouredMessage.substring(msgPos + 4, sigPos);
            text = PGPArmoury.undashProtect(text);
            try {
                this.clearText = text.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("UnsupportedEncodingException");
            }
            propPos = sigPos + 33;
        } else {
            startPos = armouredMessage.indexOf("-----BEGIN ");
            if (startPos != -1) {
                propPos = armouredMessage.indexOf("\r\n", startPos);
                this.type = armouredMessage.substring(startPos + 11, (propPos += 2) - 7);
            } else {
                throw new IllegalArgumentException("Armoured Data without recognised -----BEGIN");
            }
        }
        msgPos = armouredMessage.indexOf("\r\n\r\n", propPos);
        propString = armouredMessage.substring(propPos, msgPos);
        this.stringToHeaders(propString, this.headers);
        this.payload = PGPArmoury.unarmour(armouredMessage.substring(msgPos + 4));
    }

    static String removeTrailingWhitespace(String s) {
        String result = s;
        if (result.length() > 0) {
            while (result.substring(result.length() - 1).equals("\t") || result.substring(result.length() - 1).equals(" ")) {
                if ((result = result.substring(0, result.length() - 1)).length() == 0) break;
            }
        }
        return result;
    }

    private void stringToHeaders(String s, Properties head) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(s, "\r\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int pos = line.indexOf(": ");
            if (pos == -1) {
                throw new IllegalArgumentException("Header \"" + line + "\" does not conform to PGP standard \"Name: Value\"");
            }
            String name = line.substring(0, pos);
            if (name.length() <= 0) continue;
            String value = line.substring(pos + 2);
            ((Hashtable)head).put(name.toLowerCase(), value);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(8192);
        if (this.clearText != null) {
            String text = "";
            try {
                text = new String(this.clearText, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError("UnsupportedEncodingException");
            }
            text = PGPArmoury.fixLineEndings(text, "\r\n");
            text = PGPArmoury.dashProtect(text);
            sb.append("-----BEGIN PGP SIGNED MESSAGE-----\r\n");
            if (((Hashtable)this.headers).containsKey("Hash")) {
                sb.append("Hash: " + this.headers.getProperty("Hash") + "\r\n");
                ((Hashtable)this.headers).remove("Hash");
            }
            sb.append("\r\n" + text);
            sb.append("\r\n-----BEGIN PGP SIGNATURE-----\r\n");
            sb.append(this.headersToString(this.headers));
            sb.append(PGPArmoury.armour(this.payload));
            sb.append("-----END PGP SIGNATURE-----\r\n");
        } else {
            sb.append("-----BEGIN " + this.type + "-----\r\n");
            sb.append(this.headersToString(this.headers));
            sb.append(PGPArmoury.armour(this.payload));
            sb.append("-----END " + this.type + "-----\r\n");
        }
        return new String(sb);
    }

    public static byte[] unarmour(String s) {
        int calculatedCRC;
        int crcPos = s.indexOf("\r\n=");
        String mainEncodedString = s.substring(0, crcPos);
        byte[] mainBytes = PGPBase64.decode(mainEncodedString);
        String crcEncodedString = s.substring(crcPos + 3, crcPos + 7);
        byte[] crcBytes = PGPBase64.decode(crcEncodedString);
        int crcInt = (crcBytes[0] & 0xFF) << 16 | (crcBytes[1] & 0xFF) << 8 | crcBytes[2] & 0xFF;
        if (crcInt != (calculatedCRC = PGPCRC.checksum(mainBytes))) {
            throw new IllegalArgumentException("Armoured Data has incorrect CRC");
        }
        return mainBytes;
    }

    public static String undashProtect(String s) {
        int startPos = s.startsWith("- ") ? 2 : 0;
        int len = s.length();
        StringBuffer buffer = new StringBuffer(len);
        while (startPos < len) {
            int nextPos = s.indexOf("\r\n- ", startPos);
            if (nextPos == -1) {
                buffer.append(s.substring(startPos));
                startPos = len;
                continue;
            }
            buffer.append(s.substring(startPos, nextPos + 2));
            startPos = nextPos + 4;
        }
        return buffer.toString();
    }
}

