/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.backend;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.util.LinkedList;
import nu.fw.jeti.backend.ConnectionPacketReceiver;
import nu.fw.jeti.backend.KeepAlivePacket;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.util.Log;
import nu.fw.jeti.util.Preferences;

public class Output
extends Thread {
    private Writer out;
    private LinkedList queue = new LinkedList();
    private volatile boolean isRunning = true;
    private volatile boolean closeSocketOnExit = true;
    private Socket socket;
    public static final int KEEP_ALIVE = 60000;
    private KeepAlivePacket keepAlivePacket = new KeepAlivePacket();
    private ConnectionPacketReceiver backend;
    private volatile boolean authenticated = false;
    private String host;

    public Output(Socket socket, String string, ConnectionPacketReceiver connectionPacketReceiver, OutputStream outputStream) throws IOException {
        this.socket = socket;
        this.backend = connectionPacketReceiver;
        this.host = string;
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.writeHeader();
        this.start();
    }

    public void writeHeader() throws IOException {
        this.out.write("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.write("<stream:stream xmlns:stream='http://etherx.jabber.org/streams' ");
        this.out.write("xmlns='jabber:client' ");
        if (PluginsInfo.isPluginLoaded("xmpp")) {
            this.out.write("version='1.0' ");
        }
        this.out.write("to='");
        this.out.write(this.host);
        String string = Preferences.getString("jeti", "language", null);
        if (string != null) {
            String string2 = Preferences.getString("jeti", "country", null);
            if (string2 != null) {
                string = string + "-" + string2;
            }
            this.out.write("' xml:lang='");
            this.out.write(string);
        }
        this.out.write("'>");
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet) {
        if (this.isRunning) {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(packet);
                this.queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean bl) {
        this.closeSocketOnExit = bl;
        this.isRunning = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    public void setAuthenticated() {
        this.authenticated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        while (this.isRunning || !this.queue.isEmpty()) {
            Packet packet;
            Object object = this.queue;
            synchronized (object) {
                if (this.queue.isEmpty()) {
                    if (this.isRunning) {
                        try {
                            this.queue.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            return;
                        }
                        if (this.authenticated && this.queue.isEmpty()) {
                            this.queue.add(this.keepAlivePacket);
                        }
                    }
                    continue;
                }
                packet = (Packet)this.queue.removeFirst();
            }
            object = packet.toString();
            try {
                Log.sendXML((String)object);
                this.out.write((String)object);
                this.out.flush();
            }
            catch (IOException iOException) {
                if (!this.socket.isClosed()) {
                    Log.notSend((String)object);
                    if (this.isRunning) {
                        this.backend.outputDeath();
                    }
                    try {
                        System.out.println("closing socket");
                        this.socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        if (this.closeSocketOnExit && !this.socket.isClosed()) {
            try {
                this.out.write("</stream:stream>");
                this.out.flush();
                System.out.println("closing socket");
                this.socket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

