/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.XMLDataFile;
import nu.fw.jeti.plugins.PluginsHandler;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginData
extends XMLDataFile {
    private List plugins = Preferences.getPlugins();

    public PluginData() {
    }

    public PluginData(SAXParser sAXParser) {
        InputStream inputStream = null;
        inputStream = this.getClass().getResourceAsStream("/plugins.xml");
        if (inputStream == null) {
            try {
                inputStream = new URL(Start.programURL + "plugins.xml").openStream();
            }
            catch (IOException iOException) {
                this.scanPlugins();
            }
        }
        if (inputStream != null) {
            try {
                sAXParser.parse(new InputSource(new InputStreamReader(inputStream)), (DefaultHandler)new PluginsHandler(this.plugins));
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Iterator iterator = this.plugins.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                if (objectArray[2] != null) continue;
                iterator.remove();
            }
        }
    }

    public void scanPlugins() {
        Object object;
        ArrayList arrayList = new ArrayList(this.plugins);
        this.plugins.clear();
        this.searchPlugins(Start.pluginPath + "plugins");
        try {
            object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Start.pluginPath + "plugins.xml"), "UTF8"));
            ((Writer)object).write(this.toString());
            ((BufferedWriter)object).close();
        }
        catch (Exception exception) {
            System.err.println("Failed to save 'plugins.xml': " + exception.getMessage());
        }
        object = arrayList.iterator();
        block2: while (object.hasNext()) {
            Object[] objectArray = (Object[])object.next();
            Iterator iterator = this.plugins.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray2 = (Object[])iterator.next();
                if (!objectArray[0].equals(objectArray2[0])) continue;
                objectArray2[1] = objectArray[1];
                continue block2;
            }
        }
    }

    private void searchPlugins(String string) {
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                System.err.println(MessageFormat.format(I18N.gettext("main.error.{0}_contains_no_plugins"), string));
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.toString().endsWith(".jar")) continue;
                this.getPluginInfo(file2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getPluginInfo(File file) {
        Object object;
        URL[] uRLArray = new URL[1];
        try {
            uRLArray[0] = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String string = file.getName();
        string = string.substring(0, string.length() - 4);
        Class<?> clazz = null;
        try {
            object = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
            clazz = ((ClassLoader)object).loadClass("nu.fw.jeti.plugins." + string + ".Plugin");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            object = clazz.getField("NAME").get(null).toString();
            boolean bl = false;
            Object[] objectArray = this.plugins.iterator();
            while (objectArray.hasNext()) {
                Object[] objectArray2 = (Object[])objectArray.next();
                if (!((String)object).equals(objectArray2[0])) continue;
                this.fillPluginsDef(objectArray2, clazz, (String)object);
                bl = true;
                break;
            }
            if (!bl) {
                objectArray = new Object[6];
                this.fillPluginsDef(objectArray, clazz, (String)object);
                objectArray[1] = Boolean.FALSE;
                this.plugins.add(objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fillPluginsDef(Object[] objectArray, Class clazz, String string) throws Exception {
        objectArray[0] = string;
        objectArray[2] = clazz.getField("DESCRIPTION").get(null).toString();
        objectArray[3] = clazz.getField("VERSION").get(null).toString();
        objectArray[4] = clazz.getField("MIN_JETI_VERSION").get(null).toString();
        try {
            objectArray[5] = clazz.getField("PARENT").get(null).toString();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public List getPlugins() {
        return this.plugins;
    }

    public void appendToXML(StringBuffer stringBuffer) {
        this.appendHeader(stringBuffer);
        this.appendOpenTag(stringBuffer, "<plugins>");
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            this.appendOpenTag(stringBuffer, "<plugin>");
            Object[] objectArray = (Object[])iterator.next();
            this.appendElement(stringBuffer, "name", (String)objectArray[0]);
            this.appendElement(stringBuffer, "description", (String)objectArray[2]);
            this.appendElement(stringBuffer, "version", (String)objectArray[3]);
            this.appendElement(stringBuffer, "min_jeti_version", (String)objectArray[4]);
            this.appendElement(stringBuffer, "parent", (String)objectArray[5]);
            this.appendCloseTag(stringBuffer, "</plugin>");
        }
        this.appendCloseTag(stringBuffer, "</plugins>");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Arguments: dir_to_scan outfile");
            System.exit(1);
        }
        new Preferences();
        PluginData pluginData = new PluginData();
        pluginData.plugins.clear();
        pluginData.searchPlugins(stringArray[0]);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(stringArray[1]), "UTF8"));
            bufferedWriter.write(pluginData.toString());
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("Failed to write file: " + iOException);
            System.exit(1);
        }
    }
}

