/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.IQXRoster;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.RosterItem;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Utils;

public class GroupDialog
extends JDialog {
    private JPanel btnPanel = new JPanel();
    private JLabel lbltekst = new JLabel();
    private JComboBox cmbGroup;
    private JButton btnCancel = new JButton();
    private JButton btnOK = new JButton();
    private String[] groups;
    private Backend backend;
    private String currentGroup;
    private JIDStatus jidStatus;

    public GroupDialog(JIDStatus jIDStatus, Backend backend) {
        super(backend.getMainFrame(), I18N.gettext("main.main.rostermenu.Add_to_Group"), false);
        this.groups = backend.getAllGroups();
        String[] stringArray = new String[this.groups.length - 1];
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (jIDStatus.isGroupPresent(this.groups[i])) continue;
            stringArray[n] = this.groups[i];
            ++n;
        }
        this.groups = new String[n];
        System.arraycopy(stringArray, 0, this.groups, 0, n);
        this.init(jIDStatus, backend);
        this.lbltekst.setText(MessageFormat.format(I18N.gettext("main.popup.Add_{0}_to"), jIDStatus.getNick()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void init(JIDStatus jIDStatus, Backend backend) {
        this.backend = backend;
        this.jidStatus = jIDStatus;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public GroupDialog(String string, JIDStatus jIDStatus, Backend backend) {
        super(backend.getMainFrame(), I18N.gettext("main.main.rostermenu.Change_Group"), false);
        this.groups = backend.getAllGroups();
        String[] stringArray = new String[this.groups.length - 1];
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (jIDStatus.isGroupPresent(this.groups[i])) continue;
            stringArray[n] = this.groups[i];
            ++n;
        }
        this.groups = new String[n];
        System.arraycopy(stringArray, 0, this.groups, 0, n);
        this.currentGroup = string;
        this.init(jIDStatus, backend);
        this.lbltekst.setText(MessageFormat.format(I18N.gettext("main.popup.Change_{0}_from_{1}_to"), jIDStatus.getNick(), string));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.cmbGroup = new JComboBox<String>(this.groups);
        this.cmbGroup.setAlignmentX(0.0f);
        this.cmbGroup.setEditable(true);
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupDialog.this.dispose();
            }
        };
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.btnOK.setText(I18N.gettext("OK"));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupDialog.this.btnOK_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.lbltekst, gridBagConstraints);
        this.getContentPane().add((Component)this.cmbGroup, gridBagConstraints);
        this.btnPanel.add((Component)this.btnOK, null);
        this.btnPanel.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)this.btnPanel, gridBagConstraints);
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.cmbGroup.getSelectedItem();
        if (!string.equals(" ")) {
            List list = this.jidStatus.getGroupsCopy();
            if (this.currentGroup != null) {
                list.remove(this.currentGroup);
                list.add(string);
                IQXRoster iQXRoster = new IQXRoster(new RosterItem(this.jidStatus.getJID(), this.jidStatus.getNick(), null, null, list));
                this.backend.send(new InfoQuery("set", iQXRoster));
            } else if (!this.jidStatus.isGroupPresent(string)) {
                list.add(string);
                IQXRoster iQXRoster = new IQXRoster(new RosterItem(this.jidStatus.getJID(), this.jidStatus.getNick(), null, null, list));
                this.backend.send(new InfoQuery("set", iQXRoster));
            }
        }
        this.dispose();
    }
}

