/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicArrowButton;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.ui.StatusButton;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.Utils;

public class StatusMessagesWindow
extends JFrame {
    private JPanel jPanel1 = new JPanel();
    private JToggleButton btnChat = new JToggleButton();
    private JToggleButton btnAvailable = new JToggleButton();
    private JToggleButton btnDnD = new JToggleButton();
    private JToggleButton btnAway = new JToggleButton();
    private JToggleButton btnXA = new JToggleButton();
    private JPanel jPanel2 = new JPanel();
    private JButton btnOK = new JButton();
    private JButton btnCancel = new JButton();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JButton btnAdd = new JButton();
    private JButton btnRemove = new JButton();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel[] messagePanels = new JPanel[5];
    private JButton btnUp = new BasicArrowButton(5);
    private JButton btnDown = new BasicArrowButton(1);
    private int selectedStatus = 2;
    private JTextField selectedTextField;

    public StatusMessagesWindow() {
        for (int i = 0; i < 5; ++i) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            List list = Preferences.getStatusMessages(i + 1);
            for (int j = 0; j < list.size(); ++j) {
                JTextField jTextField = new JTextField((String)list.get(j));
                jTextField.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                        StatusMessagesWindow.this.selectedTextField = (JTextField)focusEvent.getSource();
                    }
                });
                jPanel.add(jTextField);
            }
            this.messagePanels[i] = jPanel;
        }
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(I18N.gettext("main.statusmessages.Manage_Status_Messages"));
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        Dimension dimension = new Dimension(Integer.MAX_VALUE, 27);
        this.btnChat.setMaximumSize(dimension);
        this.btnChat.setText(I18N.gettext("main.presence.Free_for_Chat"));
        this.btnChat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.messageButtons_actionPerformed(actionEvent);
            }
        });
        this.btnAvailable.setMaximumSize(new Dimension(dimension));
        this.btnAvailable.setSelected(true);
        this.btnAvailable.setText(I18N.gettext("main.presence.Available"));
        this.btnAvailable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.messageButtons_actionPerformed(actionEvent);
            }
        });
        this.btnDnD.setMaximumSize(dimension);
        this.btnDnD.setText(I18N.gettext("main.presence.Do_not_Disturb"));
        this.btnDnD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.messageButtons_actionPerformed(actionEvent);
            }
        });
        this.btnAway.setMaximumSize(dimension);
        this.btnAway.setText(I18N.gettext("main.presence.Away"));
        this.btnAway.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.messageButtons_actionPerformed(actionEvent);
            }
        });
        this.btnXA.setText(I18N.gettext("main.presence.Extended_Away"));
        this.btnXA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.messageButtons_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.btnOK.setText(I18N.gettext("OK"));
        this.getRootPane().setDefaultButton(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.btnOK_actionPerformed(actionEvent);
            }
        });
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.dispose();
            }
        };
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.jPanel3.setLayout(new BorderLayout());
        I18N.setTextAndMnemonic("main.statusmessages.Add", this.btnAdd);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.btnAdd_actionPerformed(actionEvent);
            }
        });
        I18N.setTextAndMnemonic("main.statusmessages.Remove", this.btnRemove);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.btnRemove_actionPerformed(actionEvent);
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.btnUp_actionPerformed(actionEvent);
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusMessagesWindow.this.btnDown_actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.btnChat, null);
        this.jPanel1.add((Component)this.btnAvailable, null);
        this.jPanel1.add((Component)this.btnDnD, null);
        this.jPanel1.add((Component)this.btnAway, null);
        this.jPanel1.add((Component)this.btnXA, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.btnOK, null);
        this.jPanel2.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.btnAdd, null);
        this.jPanel4.add((Component)this.btnRemove, null);
        this.jPanel4.add((Component)this.btnUp, null);
        this.jPanel4.add((Component)this.btnDown, null);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add(this.messagePanels[this.selectedStatus - 1]);
    }

    void messageButtons_actionPerformed(ActionEvent actionEvent) {
        this.btnChat.setSelected(false);
        this.btnAvailable.setSelected(false);
        this.btnDnD.setSelected(false);
        this.btnAway.setSelected(false);
        this.btnXA.setSelected(false);
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        jToggleButton.setSelected(true);
        String string = jToggleButton.getText();
        this.selectedStatus = string.equals(I18N.gettext("main.presence.Free_for_Chat")) ? 1 : (string.equals(I18N.gettext("main.presence.Available")) ? 2 : (string.equals(I18N.gettext("main.presence.Do_not_Disturb")) ? 4 : (string.equals(I18N.gettext("main.presence.Away")) ? 3 : 5)));
        this.jScrollPane1.getViewport().add(this.messagePanels[this.selectedStatus - 1]);
        this.jScrollPane1.validate();
    }

    void btnAdd_actionPerformed(ActionEvent actionEvent) {
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                StatusMessagesWindow.this.selectedTextField = (JTextField)focusEvent.getSource();
            }
        });
        this.messagePanels[this.selectedStatus - 1].add(jTextField);
        this.messagePanels[this.selectedStatus - 1].validate();
        this.jScrollPane1.validate();
    }

    void btnRemove_actionPerformed(ActionEvent actionEvent) {
        if (this.selectedTextField != null) {
            this.messagePanels[this.selectedStatus - 1].remove(this.selectedTextField);
            this.messagePanels[this.selectedStatus - 1].validate();
            this.messagePanels[this.selectedStatus - 1].updateUI();
        }
    }

    void btnUp_actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = this.messagePanels[this.selectedStatus - 1];
        Component[] componentArray = jPanel.getComponents();
        for (int i = 0; i < componentArray.length - 1; ++i) {
            if (!componentArray[i].equals(this.selectedTextField)) continue;
            JTextField jTextField = (JTextField)componentArray[i + 1];
            String string = this.selectedTextField.getText();
            this.selectedTextField.setText(jTextField.getText());
            jTextField.setText(string);
            this.selectedTextField = jTextField;
            jPanel.validate();
            return;
        }
    }

    void btnDown_actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = this.messagePanels[this.selectedStatus - 1];
        Component[] componentArray = jPanel.getComponents();
        for (int i = 1; i < componentArray.length; ++i) {
            if (!componentArray[i].equals(this.selectedTextField)) continue;
            JTextField jTextField = (JTextField)componentArray[i - 1];
            String string = this.selectedTextField.getText();
            this.selectedTextField.setText(jTextField.getText());
            jTextField.setText(string);
            this.selectedTextField = jTextField;
            jPanel.validate();
            return;
        }
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < 5; ++i) {
            Component[] componentArray = this.messagePanels[i].getComponents();
            ArrayList<String> arrayList = new ArrayList<String>(componentArray.length);
            for (int j = 0; j < componentArray.length; ++j) {
                arrayList.add(((JTextField)componentArray[j]).getText());
            }
            Preferences.saveStatusMessages(i + 1, arrayList);
        }
        Preferences.saveToServer();
        StatusButton.reloadMessages();
        this.dispose();
    }
}

