/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.util;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.XMLDataFile;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.IQPrivate;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.JetiPrivateExtension;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.PreferencesHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Preferences
extends XMLDataFile {
    private static Map mapMessages = new HashMap();
    private static Backend backend;
    private static Map plugable;
    private static Map preferences;
    private static Map defaults;

    public Preferences() {
    }

    public Preferences(Map map) {
        preferences.putAll(map);
    }

    public Preferences(Backend backend, SAXParser sAXParser) {
        URL uRL;
        Preferences.backend = backend;
        InputStream inputStream = null;
        inputStream = this.getClass().getResourceAsStream("/default_preferences.xml");
        if (inputStream != null) {
            System.out.println("loading default prefs");
            this.addPreferences(sAXParser, inputStream, preferences);
        } else {
            try {
                inputStream = new FileInputStream(Start.path + "default_preferences.xml");
                this.addPreferences(sAXParser, inputStream, preferences);
                System.out.println("loading default prefs");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (Start.applet) {
                uRL = new URL(Start.dataURL + "preferences.xml");
                inputStream = uRL.openStream();
            } else {
                inputStream = new FileInputStream(Start.path + "preferences.xml");
            }
            this.addPreferences(sAXParser, inputStream, preferences);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (Start.applet) {
                uRL = new URL(Start.dataURL + "default.xml");
                inputStream = uRL.openStream();
                System.out.println("default loaded");
            } else {
                inputStream = new FileInputStream(Start.path + "default.xml");
            }
            this.addPreferences(sAXParser, inputStream, defaults);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mapMessages.isEmpty()) {
            Preferences.initMessages(mapMessages);
        }
    }

    private void addPreferences(SAXParser sAXParser, InputStream inputStream, Map map) {
        try {
            sAXParser.parse(inputStream, (DefaultHandler)new PreferencesHandler(map));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static Map initMessages(Map map) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        arrayList.add("Available");
        arrayList.add("Free for Chat");
        map.put("chat", arrayList);
        map.put("available", arrayList);
        arrayList = new ArrayList(10);
        arrayList.add("In a Meeting");
        arrayList.add("Busy");
        arrayList.add("Working");
        map.put("dnd", arrayList);
        arrayList = new ArrayList(10);
        arrayList.add("On the Phone");
        arrayList.add("Be Right Back");
        map.put("away", arrayList);
        arrayList = new ArrayList(10);
        arrayList.add("Out to Dinner");
        arrayList.add("Out to Lunch");
        arrayList.add("On Vacation");
        arrayList.add("Gone Home");
        arrayList.add("Sleeping");
        arrayList.add("Extend Away");
        map.put("xa", arrayList);
        return map;
    }

    public static void addDefaultPreferences(String string, String string2) {
        defaults.put(string, string2);
    }

    public static void load(JetiPrivateExtension jetiPrivateExtension) {
        mapMessages.putAll(jetiPrivateExtension.getMessages());
    }

    public static void saveStatusMessages(int n, List list) {
        mapMessages.put(Preferences.convertPresenceKey(n), list);
    }

    public static void saveToServer() {
        backend.send(new InfoQuery("set", new IQPrivate(new JetiPrivateExtension(null, mapMessages))));
    }

    public static List getStatusMessages(int n) {
        return (List)mapMessages.get(Preferences.convertPresenceKey(n));
    }

    private static String convertPresenceKey(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "chat";
                break;
            }
            case 3: {
                string = "away";
                break;
            }
            case 5: {
                string = "xa";
                break;
            }
            case 4: {
                string = "dnd";
                break;
            }
            default: {
                string = "available";
            }
        }
        return string;
    }

    public static boolean getBoolean(String string, String string2, boolean bl) {
        String string3 = Preferences.get(string, string2);
        if (string3 == null) {
            return bl;
        }
        return Boolean.valueOf(string3);
    }

    public static void putBoolean(String string, String string2, boolean bl) {
        preferences.put(string + "." + string2, String.valueOf(bl));
    }

    public static int getInteger(String string, String string2, int n) {
        String string3 = Preferences.get(string, string2);
        if (string3 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static void putInteger(String string, String string2, int n) {
        preferences.put(string + "." + string2, String.valueOf(n));
    }

    public static void putString(String string, String string2, String string3) {
        preferences.put(string + "." + string2, string3);
    }

    public static String getString(String string, String string2, String string3) {
        String string4 = Preferences.get(string, string2);
        if (string4 == null) {
            return string3;
        }
        return string4;
    }

    private static String get(String string, String string2) {
        String string3 = (String)defaults.get(string + "." + string2);
        if (string3 != null) {
            return string3;
        }
        return (String)preferences.get(string + "." + string2);
    }

    public static List getPlugins() {
        return Preferences.getPlugable("plugins");
    }

    public static List getTranslatedPlugins() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Iterator iterator = Preferences.getPlugins().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = new Object[6];
            Object[] objectArray2 = (Object[])iterator.next();
            objectArray[0] = objectArray2[0];
            objectArray[1] = objectArray2[1];
            objectArray[2] = I18N.gettext((String)objectArray2[2]);
            objectArray[3] = objectArray2[3];
            objectArray[4] = objectArray2[4];
            objectArray[5] = objectArray2[5];
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    public static List getPlugable(String string) {
        ArrayList arrayList = (ArrayList)plugable.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            plugable.put(string, arrayList);
        }
        return arrayList;
    }

    public static List getPlugableCopy(String string) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Iterator iterator = Preferences.getPlugable(string).iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = new Object[6];
            System.arraycopy(iterator.next(), 0, objectArray, 0, 6);
            arrayList.add(objectArray);
        }
        return arrayList;
    }

    public static void save() {
        StringBuffer stringBuffer = new StringBuffer();
        new Preferences().appendToXML(stringBuffer);
        stringBuffer.insert(0, "<?xml version='1.0'?>");
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Start.path + "preferences.xml"), "UTF8"));
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void appendToXML(StringBuffer stringBuffer) {
        Object object;
        String string;
        Map.Entry entry;
        this.appendOpenTag(stringBuffer, "<preferences>");
        Iterator iterator = preferences.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            object = (String)entry.getValue();
            if (object == null) continue;
            this.appendOpenTag(stringBuffer, "<preference");
            this.appendAttribute(stringBuffer, "key", string);
            this.appendAttribute(stringBuffer, "value", (String)object);
            this.appendCloseSymbol(stringBuffer);
        }
        this.appendOpenTag(stringBuffer, "<plugins>");
        iterator = plugable.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            object = ((List)entry.getValue()).iterator();
            while (object.hasNext()) {
                Object[] objectArray = (Object[])object.next();
                this.appendOpenTag(stringBuffer, "<plugin");
                this.appendAttribute(stringBuffer, "type", string);
                this.appendAttribute(stringBuffer, "name", objectArray[0]);
                this.appendAttribute(stringBuffer, "enabled", objectArray[1]);
                this.appendAttribute(stringBuffer, "transport", objectArray[3]);
                this.appendCloseSymbol(stringBuffer);
            }
        }
        this.appendCloseTag(stringBuffer, "</plugins>");
        this.appendCloseTag(stringBuffer, "</preferences>");
    }

    static {
        plugable = new HashMap();
        preferences = new HashMap();
        defaults = new HashMap();
    }
}

