/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.util.Iterator;
import java.util.Map;
import nu.fw.jeti.events.RegisterListener;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;

public class IQRegister
extends Extension
implements IQExtension {
    private boolean remove = false;
    private Map fields;
    private XData xdata;
    private String password;
    private String username;

    public IQRegister() {
    }

    public IQRegister(String string, String string2) {
        this.password = string2;
        this.username = string;
    }

    public IQRegister(XData xData) {
        this.xdata = xData;
    }

    public IQRegister(boolean bl, Map map, XData xData) {
        this.remove = bl;
        this.fields = map;
        this.xdata = xData;
    }

    public IQRegister(boolean bl, Map map) {
        this.remove = bl;
        this.fields = map;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public Map getFields() {
        return this.fields;
    }

    public XData getXData() {
        return this.xdata;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        if (infoQuery.getType().equals("result")) {
            Iterator iterator = backend.getListeners(RegisterListener.class);
            while (iterator.hasNext()) {
                ((RegisterListener)iterator.next()).register(this, infoQuery.getID());
            }
        } else if (infoQuery.getType().equals("error")) {
            Popups.errorPopup(infoQuery.getErrorDescription(), I18N.gettext("main.error.Register_Error"));
        }
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<query xmlns=\"jabber:iq:register\"");
        if (this.username == null && this.fields == null && !this.remove && this.xdata == null) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append('>');
        if (this.username != null) {
            IQRegister.appendElement(stringBuffer, "username", this.username);
            IQRegister.appendElement(stringBuffer, "password", this.password);
        } else {
            IQRegister.appendElement(stringBuffer, this.fields);
            IQRegister.appendElement(stringBuffer, "remove", this.remove);
            if (this.xdata != null) {
                this.xdata.appendToXML(stringBuffer);
            }
        }
        stringBuffer.append("</query>");
    }
}

