/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.util.LinkedList;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.Packet;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;

public abstract class PacketBuilder {
    public JID to;
    public JID from;
    public String id;
    public int errorCode;
    public String errorDescription;
    private String type;
    public XMPPError xmppError;
    private LinkedList extensions;

    public void reset() {
        this.to = null;
        this.from = null;
        this.id = null;
        this.extensions = null;
        this.errorCode = 0;
        this.xmppError = null;
        this.type = null;
        this.errorDescription = null;
    }

    public void setTo(JID jID) {
        this.to = jID;
    }

    public void setFrom(JID jID) {
        this.from = jID;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setErrorType(String string) {
        this.type = string;
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public void setErrorDescription(String string) {
        this.errorDescription = string;
    }

    public void addExtension(Extension extension) {
        if (extension == null) {
            return;
        }
        if (extension instanceof XMPPErrorTag) {
            if (this.xmppError == null) {
                this.xmppError = new XMPPError(this.type, this.errorCode);
            }
            this.xmppError.addError((XMPPErrorTag)extension);
        } else {
            if (this.extensions == null) {
                this.extensions = new LinkedList();
            }
            this.extensions.add(extension);
        }
    }

    public LinkedList getExtensions() {
        return this.extensions;
    }

    public abstract Packet build() throws InstantiationException;
}

