/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.handlers;

import java.util.LinkedList;
import java.util.List;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.XData;
import nu.fw.jeti.jabber.elements.XDataBuilder;
import nu.fw.jeti.jabber.elements.XDataFieldBuilder;
import nu.fw.jeti.jabber.handlers.ExtensionHandler;
import nu.fw.jeti.util.Log;
import org.xml.sax.Attributes;

public class XDataHandler
extends ExtensionHandler {
    private XDataBuilder builder = new XDataBuilder();
    private XDataFieldBuilder fieldBuilder = new XDataFieldBuilder();
    private String label;
    private String value;
    private boolean inOption;
    private boolean multiple;
    private boolean reported;
    private List items;

    public void startHandling(Attributes attributes) {
        this.inOption = false;
        this.label = null;
        this.value = null;
        this.multiple = false;
        this.reported = false;
        this.builder.reset();
        this.builder.type = attributes.getValue("type");
    }

    public void startElement(String string, Attributes attributes) {
        if (string.equals("reported")) {
            this.multiple = true;
            this.reported = true;
        }
        if (string.equals("item")) {
            this.items = new LinkedList();
        }
        if (string.equals("field")) {
            this.fieldBuilder.reset();
            this.fieldBuilder.label = attributes.getValue("label");
            this.fieldBuilder.var = attributes.getValue("var");
            this.fieldBuilder.type = attributes.getValue("type");
        } else if (string.equals("option")) {
            this.inOption = true;
            this.label = attributes.getValue("label");
        }
    }

    public void endElement(String string) {
        if (string.equals("field")) {
            if (this.reported) {
                this.builder.addReportedField(this.fieldBuilder.build());
            } else if (this.multiple && this.items != null) {
                this.items.add(this.fieldBuilder.build());
            } else {
                this.builder.addField(this.fieldBuilder.build());
            }
        } else if (string.equals("title")) {
            this.builder.title = this.getText();
        } else if (string.equals("instructions")) {
            this.builder.addInstructions(this.getText());
        } else if (string.equals("desc")) {
            this.fieldBuilder.addDescription(this.getText());
        } else if (string.equals("required")) {
            this.fieldBuilder.required = true;
        } else if (string.equals("option")) {
            this.fieldBuilder.addOption(this.label, this.value);
            this.inOption = false;
            this.label = null;
            this.value = null;
        } else if (string.equals("value")) {
            if (this.inOption) {
                this.value = this.getText();
            } else {
                this.fieldBuilder.addValue(this.getText());
            }
        } else if (string.equals("reported")) {
            this.reported = false;
        } else if (string.equals("item")) {
            this.builder.addItem(this.items);
        } else {
            Log.notParsedXML("XData " + string + this.getText());
        }
        this.clearCurrentChars();
    }

    public Extension build() throws InstantiationException {
        XData xData = this.builder.build();
        this.builder.reset();
        return xData;
    }
}

