/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.plugins.PluginData;
import nu.fw.jeti.plugins.PluginsInfo;
import nu.fw.jeti.plugins.PreferencesPanel;
import nu.fw.jeti.ui.OptionsWindow;
import nu.fw.jeti.ui.models.ListTableModel;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;
import nu.fw.jeti.util.TableSorter;

public class PluginsPanel
extends PreferencesPanel {
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTable jTable1;
    private JButton jButton1 = new JButton();
    private OptionsWindow prefWindow;
    private List plugins;
    private ListTableModel dataModel;

    public PluginsPanel(OptionsWindow optionsWindow) {
        this.prefWindow = optionsWindow;
        this.plugins = Preferences.getTranslatedPlugins();
        this.dataModel = new ListTableModel(new String[]{I18N.gettext("main.options.Name"), I18N.gettext("main.options.Enabled"), I18N.gettext("main.options.Description")}, this.plugins);
        TableSorter tableSorter = new TableSorter(this.dataModel);
        this.jTable1 = new JTable(tableSorter);
        tableSorter.setTableHeader(this.jTable1.getTableHeader());
        tableSorter.setSortingStatus(0, 1);
        this.jTable1.setDefaultRenderer(String.class, new PluginRenderer());
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.setLayout(new BorderLayout());
        if (!Start.applet && new File(Start.path + "plugins").exists()) {
            this.jButton1.setText(I18N.gettext("main.options.Scan_plugins"));
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PluginsPanel.this.jButton1_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.jButton1, "South");
        }
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add(this.jTable1);
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        new PluginData().scanPlugins();
        this.dataModel.reload(Preferences.getTranslatedPlugins());
    }

    public void savePreferences() {
        List list = Preferences.getPlugins();
        List list2 = this.dataModel.getPlugins();
        for (int i = 0; i < list2.size(); ++i) {
            Object[] objectArray;
            Object[] objectArray2 = (Object[])list2.get(i);
            if (objectArray2[1].equals((objectArray = (Object[])list.get(i))[1])) continue;
            objectArray[1] = objectArray2[1];
            String string = (String)objectArray[0];
            if (((Boolean)objectArray[1]).booleanValue()) {
                PluginsInfo.loadPlugin(string);
                this.prefWindow.addPanel(string);
                continue;
            }
            PluginsInfo.unloadPlugin(string);
            this.prefWindow.removePanel(string);
        }
    }

    class PluginRenderer
    extends DefaultTableCellRenderer {
        String format = I18N.gettext("main.options.Version_{0}_(Jeti_{1})");

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n < PluginsPanel.this.plugins.size()) {
                String string = (String)((Object[])PluginsPanel.this.plugins.get(n))[3];
                String string2 = (String)((Object[])PluginsPanel.this.plugins.get(n))[4];
                this.setToolTipText(MessageFormat.format(this.format, string, string2));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

